/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBList;
import com.intellij.util.continuation.ModalityIgnorantBackgroundableTask;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.branchConfig.BranchConfigurationDialog;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.NewRootBunch;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class SelectBranchPopup {
    private static final String CONFIGURE_MESSAGE = SvnBundle.message("configure.branches.item", new Object[0]);

    private SelectBranchPopup() {
    }

    public static void show(Project project, VirtualFile file, BranchSelectedCallback callback, String title) {
        SelectBranchPopup.show(project, file, callback, title, null);
    }

    public static void show(Project project, VirtualFile file, BranchSelectedCallback callback, String title, Component component) {
        SvnFileUrlMapping urlMapping = SvnVcs.getInstance(project).getSvnFileUrlMapping();
        SVNURL svnurl = urlMapping.getUrlForFile(new File(file.getPath()));
        if (svnurl == null) {
            return;
        }
        RootUrlInfo rootUrlInfo = urlMapping.getWcRootForUrl(svnurl.toString());
        if (rootUrlInfo == null) {
            return;
        }
        SelectBranchPopup.showForBranchRoot(project, rootUrlInfo.getVirtualFile(), callback, title, component);
    }

    public static void showForBranchRoot(Project project, VirtualFile vcsRoot, BranchSelectedCallback callback, String title) {
        SelectBranchPopup.showForBranchRoot(project, vcsRoot, callback, title, null);
    }

    public static void showForBranchRoot(Project project, VirtualFile vcsRoot, BranchSelectedCallback callback, String title, Component component) {
        SvnBranchConfigurationNew configuration = SvnBranchConfigurationManager.getInstance(project).get(vcsRoot);
        ArrayList<String> items = new ArrayList<String>();
        if (!StringUtil.isEmptyOrSpaces((String)configuration.getTrunkUrl())) {
            items.add(SelectBranchPopup.getTrunkString(configuration));
        }
        for (String url : configuration.getBranchUrls()) {
            items.add(url);
        }
        items.add(CONFIGURE_MESSAGE);
        BranchBasesPopupStep step = new BranchBasesPopupStep(project, vcsRoot, configuration, callback, items, title, component);
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        step.showPopupAt((JBPopup)listPopup);
    }

    private static String getTrunkString(SvnBranchConfigurationNew configuration) {
        return configuration.getTrunkUrl() + " (trunk)";
    }

    private static class BranchRenderer
    extends JPanel
    implements ListCellRenderer {
        private final JLabel myUrlLabel = new JLabel();
        private final JLabel myDateLabel = new JLabel();

        public BranchRenderer() {
            super(new BorderLayout());
            this.add((Component)this.myUrlLabel, "West");
            this.add((Component)this.myDateLabel, "East");
            this.myUrlLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.myDateLabel.setHorizontalAlignment(4);
            this.myDateLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.myDateLabel.setForeground(UIUtil.getInactiveTextColor());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected || cellHasFocus) {
                this.setBackground(UIUtil.getListSelectionBackground());
                Color selectedForegroundColor = UIUtil.getListSelectionForeground();
                this.myUrlLabel.setForeground(selectedForegroundColor);
                this.myDateLabel.setForeground(selectedForegroundColor);
                this.setForeground(selectedForegroundColor);
            } else {
                this.setBackground(UIUtil.getListBackground());
                Color foregroundColor = UIUtil.getListForeground();
                this.myUrlLabel.setForeground(foregroundColor);
                this.myDateLabel.setForeground(UIUtil.getInactiveTextColor());
                this.setForeground(foregroundColor);
            }
            if (value instanceof String) {
                this.myUrlLabel.setText((String)value);
                this.myDateLabel.setText("");
            } else {
                SvnBranchItem item = (SvnBranchItem)value;
                this.myUrlLabel.setText(SVNPathUtil.tail((String)item.getUrl()));
                long creationMillis = item.getCreationDateMillis();
                this.myDateLabel.setText(creationMillis > 0L ? DateFormatUtil.formatDate((long)creationMillis) : "");
            }
            return this;
        }
    }

    private static class BranchBasesPopupStep
    extends BaseListPopupStep<String> {
        protected final Project myProject;
        private final VirtualFile myVcsRoot;
        private final SvnBranchConfigurationNew myConfiguration;
        private final boolean myTopLevel;
        private BranchSelectedCallback myCallback;
        private final Component myComponent;
        private static final String REFRESH_MESSAGE = SvnBundle.message("refresh.branches.item", new Object[0]);
        private String myTrunkString;

        protected BranchBasesPopupStep(Project project, VirtualFile vcsRoot, SvnBranchConfigurationNew configuration, boolean topLevel, BranchSelectedCallback callback, Component component) {
            this.myProject = project;
            this.myVcsRoot = vcsRoot;
            this.myConfiguration = configuration;
            this.myTrunkString = SelectBranchPopup.getTrunkString(configuration);
            this.myTopLevel = topLevel;
            this.myCallback = callback;
            this.myComponent = component;
        }

        public BranchBasesPopupStep(Project project, VirtualFile vcsRoot, SvnBranchConfigurationNew configuration, BranchSelectedCallback callback, List<String> items, String title, Component component) {
            this(project, vcsRoot, configuration, true, callback, component);
            this.init(title, items, null);
        }

        public ListSeparator getSeparatorAbove(String value) {
            return CONFIGURE_MESSAGE.equals(value) || REFRESH_MESSAGE.equals(value) ? new ListSeparator("") : null;
        }

        @NotNull
        public String getTextFor(String value) {
            int pos = value.lastIndexOf(47);
            if (pos < 0) {
                String string = value;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup$BranchBasesPopupStep", "getTextFor"));
                }
                return string;
            }
            if (this.myTopLevel && (this.myConfiguration.getTrunkUrl() == null || !value.startsWith(this.myConfiguration.getTrunkUrl()))) {
                String string = value.substring(pos + 1) + "...";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup$BranchBasesPopupStep", "getTextFor"));
                }
                return string;
            }
            String string = value.substring(pos + 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup$BranchBasesPopupStep", "getTextFor"));
            }
            return string;
        }

        public boolean hasSubstep(String selectedValue) {
            return false;
        }

        public PopupStep onChosen(final String selectedValue, boolean finalChoice) {
            if (CONFIGURE_MESSAGE.equals(selectedValue)) {
                return this.doFinalStep(new Runnable(){

                    @Override
                    public void run() {
                        BranchConfigurationDialog.configureBranches(BranchBasesPopupStep.this.myProject, BranchBasesPopupStep.this.myVcsRoot);
                    }
                });
            }
            if (this.myTrunkString.equals(selectedValue)) {
                return this.doFinalStep(new Runnable(){

                    @Override
                    public void run() {
                        BranchBasesPopupStep.this.myCallback.branchSelected(BranchBasesPopupStep.this.myProject, BranchBasesPopupStep.this.myConfiguration, BranchBasesPopupStep.this.myConfiguration.getTrunkUrl(), -1L);
                    }
                });
            }
            if (!this.myTopLevel || selectedValue.equals(this.myConfiguration.getTrunkUrl())) {
                return this.doFinalStep(new Runnable(){

                    @Override
                    public void run() {
                        BranchBasesPopupStep.this.myCallback.branchSelected(BranchBasesPopupStep.this.myProject, BranchBasesPopupStep.this.myConfiguration, selectedValue, -1L);
                    }
                });
            }
            this.showBranchPopup(selectedValue);
            return FINAL_CHOICE;
        }

        @Nullable
        private void loadBranches(final String selectedBranchesHolder, final Runnable runnable) {
            ProgressManager pm = ProgressManager.getInstance();
            pm.run((Task)new ModalityIgnorantBackgroundableTask(this.myProject, SvnBundle.message("compare.with.branch.progress.loading.branches", new Object[0])){

                protected void doInAwtIfFail(Exception e) {
                    runnable.run();
                }

                protected void doInAwtIfCancel() {
                    runnable.run();
                }

                protected void doInAwtIfSuccess() {
                    runnable.run();
                }

                protected void runImpl(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup$BranchBasesPopupStep$4", "runImpl"));
                    }
                    NewRootBunch manager = SvnBranchConfigurationManager.getInstance(this.myProject).getSvnBranchConfigManager();
                    manager.reloadBranches(BranchBasesPopupStep.this.myVcsRoot, selectedBranchesHolder, InfoReliability.setByUser, false);
                }
            });
        }

        private void showBranchPopup(String selectedValue) {
            List<SvnBranchItem> branches = this.myConfiguration.getBranches(selectedValue);
            if (branches == null) {
                return;
            }
            Object[] items = new Object[branches.size() + 1];
            System.arraycopy(branches.toArray(), 0, items, 0, branches.size());
            items[items.length - 1] = REFRESH_MESSAGE;
            JBList branchList = new JBList(items);
            branchList.setCellRenderer(new BranchRenderer());
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)branchList).setTitle(SVNPathUtil.tail((String)selectedValue)).setResizable(true).setItemChoosenCallback(new Runnable((JList)branchList, selectedValue){
                final /* synthetic */ JList val$branchList;
                final /* synthetic */ String val$selectedValue;
                {
                    this.val$branchList = jList;
                    this.val$selectedValue = string;
                }

                @Override
                public void run() {
                    if (REFRESH_MESSAGE.equals(this.val$branchList.getSelectedValue())) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BranchBasesPopupStep.this.loadBranches(val$selectedValue, new Runnable(){

                                    @Override
                                    public void run() {
                                        BranchBasesPopupStep.this.showBranchPopup(val$selectedValue);
                                    }
                                });
                            }
                        });
                        return;
                    }
                    SvnBranchItem item = (SvnBranchItem)this.val$branchList.getSelectedValue();
                    if (item != null) {
                        BranchBasesPopupStep.this.myCallback.branchSelected(BranchBasesPopupStep.this.myProject, BranchBasesPopupStep.this.myConfiguration, item.getUrl(), item.getRevision());
                    }
                }
            }).createPopup();
            this.showPopupAt(popup);
        }

        public void showPopupAt(JBPopup listPopup) {
            if (this.myComponent == null) {
                listPopup.showCenteredInCurrentWindow(this.myProject);
            } else {
                listPopup.showInCenterOf(this.myComponent);
            }
        }
    }

    public static interface BranchSelectedCallback {
        public void branchSelected(Project var1, SvnBranchConfigurationNew var2, String var3, long var4);
    }
}

