/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkin;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnProgressCanceller;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public class SvnCheckinEnvironment
implements CheckinEnvironment {
    private static final Logger LOG = Logger.getInstance(SvnCheckinEnvironment.class);
    @NotNull
    private final SvnVcs mySvnVcs;

    public SvnCheckinEnvironment(@NotNull SvnVcs svnVcs) {
        if (svnVcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "svnVcs", "org/jetbrains/idea/svn/checkin/SvnCheckinEnvironment", "<init>"));
        }
        this.mySvnVcs = svnVcs;
    }

    public RefreshableOnComponent createAdditionalOptionsPanel(CheckinProjectPanel panel, PairConsumer<Object, Object> additionalDataConsumer) {
        return new KeepLocksComponent();
    }

    @Nullable
    public String getDefaultMessageFor(FilePath[] filesToCheckin) {
        return null;
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    private void doCommit(@NotNull List<FilePath> committables, String comment, List<VcsException> exception, Set<String> feedback) {
        if (committables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "committables", "org/jetbrains/idea/svn/checkin/SvnCheckinEnvironment", "doCommit"));
        }
        Map<Pair<SVNURL, WorkingCopyFormat>, Set<FilePath>> map = SvnUtil.splitIntoRepositoriesMap(this.mySvnVcs, committables, Convertor.SELF);
        for (Map.Entry<Pair<SVNURL, WorkingCopyFormat>, Set<FilePath>> entry : map.entrySet()) {
            try {
                this.doCommitOneRepo((Collection<FilePath>)entry.getValue(), comment, exception, feedback, (WorkingCopyFormat)((Object)entry.getKey().getSecond()));
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
                exception.add(e);
            }
        }
    }

    private void doCommitOneRepo(@NotNull Collection<FilePath> committables, String comment, List<VcsException> exception, Set<String> feedback, @NotNull WorkingCopyFormat format) throws VcsException {
        if (committables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "committables", "org/jetbrains/idea/svn/checkin/SvnCheckinEnvironment", "doCommitOneRepo"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "org/jetbrains/idea/svn/checkin/SvnCheckinEnvironment", "doCommitOneRepo"));
        }
        if (committables.isEmpty()) {
            return;
        }
        CommitInfo[] results = this.mySvnVcs.getFactory(format).createCheckinClient().commit(ChangesUtil.filePathsToFiles(committables), comment);
        StringBuilder committedRevisions = new StringBuilder();
        for (CommitInfo result : results) {
            if (result.getErrorMessage() != null) {
                exception.add(new VcsException(result.getErrorMessage().getFullMessage()));
                continue;
            }
            if (result == CommitInfo.EMPTY || result.getRevision() <= 0L) continue;
            if (committedRevisions.length() > 0) {
                committedRevisions.append(", ");
            }
            committedRevisions.append(result.getRevision());
        }
        if (committedRevisions.length() > 0) {
            this.reportCommittedRevisions(feedback, committedRevisions.toString());
        }
    }

    private void reportCommittedRevisions(Set<String> feedback, String committedRevisions) {
        final Project project = this.mySvnVcs.getProject();
        final String message = SvnBundle.message("status.text.comitted.revision", committedRevisions);
        if (feedback == null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    new VcsBalloonProblemNotifier(project, message, MessageType.INFO).run();
                }
            }, (Condition)new Condition<Object>(){

                public boolean value(Object o) {
                    return !project.isOpen() || project.isDisposed();
                }
            });
        } else {
            feedback.add("Subversion: " + message);
        }
    }

    @NotNull
    private List<FilePath> getCommitables(@NotNull List<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/svn/checkin/SvnCheckinEnvironment", "getCommitables"));
        }
        ChangesUtil.CaseSensitiveFilePathList list = ChangesUtil.getPathsList(changes);
        for (FilePath path : ContainerUtil.newArrayList((Iterable)list.getResult())) {
            list.addParents(path, (Condition)new Condition<FilePath>(){

                public boolean value(@NotNull FilePath file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/checkin/SvnCheckinEnvironment$3", "value"));
                    }
                    Status status = SvnCheckinEnvironment.this.getStatus(file);
                    return status != null && status.is(StatusType.STATUS_ADDED, StatusType.STATUS_REPLACED);
                }
            });
        }
        List list2 = list.getResult();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/checkin/SvnCheckinEnvironment", "getCommitables"));
        }
        return list2;
    }

    @Nullable
    private Status getStatus(@NotNull FilePath file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/checkin/SvnCheckinEnvironment", "getStatus"));
        }
        Status result = null;
        try {
            result = this.mySvnVcs.getFactory(file.getIOFile()).createStatusClient().doStatus(file.getIOFile(), false);
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
        }
        return result;
    }

    public String getCheckinOperationName() {
        return SvnBundle.message("checkin.operation.name", new Object[0]);
    }

    public List<VcsException> commit(List<Change> changes, final String preparedComment, @NotNull NullableFunction<Object, Object> parametersHolder, final Set<String> feedback) {
        if (parametersHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parametersHolder", "org/jetbrains/idea/svn/checkin/SvnCheckinEnvironment", "commit"));
        }
        final ArrayList<VcsException> exception = new ArrayList<VcsException>();
        final List<FilePath> committables = this.getCommitables(changes);
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            this.doCommit(committables, preparedComment, exception, feedback);
        } else if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    SvnCheckinEnvironment.this.doCommit(committables, preparedComment, exception, feedback);
                }
            }, SvnBundle.message("progress.title.commit", new Object[0]), false, this.mySvnVcs.getProject());
        } else {
            this.doCommit(committables, preparedComment, exception, feedback);
        }
        return exception;
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment) {
        return this.commit(changes, preparedComment, (NullableFunction<Object, Object>)FunctionUtil.nullConstant(), null);
    }

    public List<VcsException> scheduleMissingFileForDeletion(List<FilePath> filePaths) {
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        List files = ChangesUtil.filePathsToFiles(filePaths);
        for (File file : files) {
            try {
                this.mySvnVcs.getFactory(file).createDeleteClient().delete(file, true, false, null);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        return exceptions;
    }

    public List<VcsException> scheduleUnversionedFilesForAddition(List<VirtualFile> files) {
        return SvnCheckinEnvironment.scheduleUnversionedFilesForAddition(this.mySvnVcs, files);
    }

    public static List<VcsException> scheduleUnversionedFilesForAddition(@NotNull SvnVcs vcs, List<VirtualFile> files) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/checkin/SvnCheckinEnvironment", "scheduleUnversionedFilesForAddition"));
        }
        return SvnCheckinEnvironment.scheduleUnversionedFilesForAddition(vcs, files, false);
    }

    public static List<VcsException> scheduleUnversionedFilesForAddition(@NotNull SvnVcs vcs, List<VirtualFile> files, boolean recursive) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/checkin/SvnCheckinEnvironment", "scheduleUnversionedFilesForAddition"));
        }
        Collections.sort(files, FilePathComparator.getInstance());
        SvnProgressCanceller eventHandler = new SvnProgressCanceller(){

            @Override
            public void consume(ProgressEvent event) throws SVNException {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                File file = event.getFile();
                if (indicator != null && file != null) {
                    indicator.setText(SvnBundle.message("progress.text2.adding", file.getName() + " (" + file.getParent() + ")"));
                }
            }
        };
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        Depth depth = Depth.allOrEmpty(recursive);
        for (VirtualFile file : files) {
            try {
                File convertedFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                vcs.getFactory(convertedFile).createAddClient().add(convertedFile, depth, true, false, true, eventHandler);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        return exceptions;
    }

    public boolean keepChangeListAfterCommit(ChangeList changeList) {
        return false;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return true;
    }

    private class KeepLocksComponent
    implements RefreshableOnComponent {
        @NotNull
        private final JCheckBox myKeepLocksBox;
        private boolean myIsKeepLocks;
        @NotNull
        private final JPanel myPanel = new JPanel(new BorderLayout());
        @NotNull
        private final JCheckBox myAutoUpdate;

        public KeepLocksComponent() {
            this.myKeepLocksBox = new JCheckBox(SvnBundle.message("checkbox.chckin.keep.files.locked", new Object[0]));
            this.myKeepLocksBox.setSelected(this.myIsKeepLocks);
            this.myAutoUpdate = new JCheckBox("Auto-update after commit");
            this.myPanel.add((Component)this.myAutoUpdate, "North");
            this.myPanel.add((Component)this.myKeepLocksBox, "Center");
        }

        public JComponent getComponent() {
            return this.myPanel;
        }

        public boolean isKeepLocks() {
            return this.myKeepLocksBox.isSelected();
        }

        public boolean isAutoUpdate() {
            return this.myAutoUpdate.isSelected();
        }

        public void refresh() {
        }

        public void saveState() {
            SvnConfiguration configuration = SvnCheckinEnvironment.this.mySvnVcs.getSvnConfiguration();
            configuration.setKeepLocks(this.isKeepLocks());
            configuration.setAutoUpdateAfterCommit(this.isAutoUpdate());
        }

        public void restoreState() {
            SvnConfiguration configuration = SvnCheckinEnvironment.this.mySvnVcs.getSvnConfiguration();
            this.myIsKeepLocks = configuration.isKeepLocks();
            this.myAutoUpdate.setSelected(configuration.isAutoUpdateAfterCommit());
        }
    }
}

