/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.continuation.Continuation;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.dialogs.MergeDialogI;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.LoadRecentBranchRevisions;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;

public class ShowRecentInDialogTask
extends BaseMergeTask {
    @NotNull
    private final LoadRecentBranchRevisions myInitialChangeListsLoader;

    public ShowRecentInDialogTask(@NotNull MergeContext mergeContext, @NotNull QuickMergeInteraction interaction, @NotNull LoadRecentBranchRevisions initialChangeListsLoader) {
        if (mergeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "org/jetbrains/idea/svn/integrate/ShowRecentInDialogTask", "<init>"));
        }
        if (interaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interaction", "org/jetbrains/idea/svn/integrate/ShowRecentInDialogTask", "<init>"));
        }
        if (initialChangeListsLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialChangeListsLoader", "org/jetbrains/idea/svn/integrate/ShowRecentInDialogTask", "<init>"));
        }
        super(mergeContext, interaction, "", Where.AWT);
        this.myInitialChangeListsLoader = initialChangeListsLoader;
    }

    public void run(ContinuationContext context) {
        List<CommittedChangeList> lists = this.myInteraction.showRecentListsForSelection(this.myInitialChangeListsLoader.getCommittedChangeLists(), this.myMergeContext.getTitle(), this.myInitialChangeListsLoader.getHelper(), this.createMoreChangeListsLoader(), this.myInitialChangeListsLoader.isLastLoaded());
        if (lists != null && !lists.isEmpty()) {
            this.runChangeListsMerge(context, lists, this.createBranchCopyPoint(), this.myMergeContext.getTitle());
        } else {
            context.cancelEverything();
        }
    }

    @NotNull
    private PairConsumer<Long, MergeDialogI> createMoreChangeListsLoader() {
        PairConsumer<Long, MergeDialogI> pairConsumer = new PairConsumer<Long, MergeDialogI>(){

            public void consume(@NotNull Long bunchSize, @NotNull MergeDialogI dialog) {
                if (bunchSize == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bunchSize", "org/jetbrains/idea/svn/integrate/ShowRecentInDialogTask$1", "consume"));
                }
                if (dialog == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "org/jetbrains/idea/svn/integrate/ShowRecentInDialogTask$1", "consume"));
                }
                LoadRecentBranchRevisions loader = new LoadRecentBranchRevisions(ShowRecentInDialogTask.this.myMergeContext, dialog.getLastNumber(), bunchSize.intValue());
                TaskDescriptor updater = ShowRecentInDialogTask.createUpdateDialogTask(dialog, loader);
                Continuation fragmented = Continuation.createFragmented((Project)ShowRecentInDialogTask.this.myMergeContext.getProject(), (boolean)true);
                fragmented.addExceptionHandler(VcsException.class, (Consumer)new Consumer<VcsException>(){

                    public void consume(VcsException e) {
                        PopupUtil.showBalloonForActiveComponent((String)(e.getMessage() == null ? ((Object)((Object)e)).getClass().getName() : e.getMessage()), (MessageType)MessageType.ERROR);
                    }
                });
                fragmented.run(new TaskDescriptor[]{loader, updater});
            }
        };
        if (pairConsumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/ShowRecentInDialogTask", "createMoreChangeListsLoader"));
        }
        return pairConsumer;
    }

    @NotNull
    private SvnBranchPointsCalculator.WrapperInvertor createBranchCopyPoint() {
        SvnBranchPointsCalculator.WrapperInvertor wrapperInvertor = new SvnBranchPointsCalculator.WrapperInvertor(false, new SvnBranchPointsCalculator.BranchCopyData(this.myMergeContext.getWcInfo().getUrl().toString(), -1L, this.myMergeContext.getSourceUrl(), -1L));
        if (wrapperInvertor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/ShowRecentInDialogTask", "createBranchCopyPoint"));
        }
        return wrapperInvertor;
    }

    @NotNull
    private static TaskDescriptor createUpdateDialogTask(final @NotNull MergeDialogI dialog, final @NotNull LoadRecentBranchRevisions loader) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "org/jetbrains/idea/svn/integrate/ShowRecentInDialogTask", "createUpdateDialogTask"));
        }
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "org/jetbrains/idea/svn/integrate/ShowRecentInDialogTask", "createUpdateDialogTask"));
        }
        TaskDescriptor taskDescriptor = new TaskDescriptor("", Where.AWT){

            public void run(ContinuationContext context) {
                dialog.addMoreLists(loader.getCommittedChangeLists());
                if (loader.isLastLoaded()) {
                    dialog.setEverythingLoaded(true);
                }
            }

            public void canceled() {
                dialog.addMoreLists(Collections.<CommittedChangeList>emptyList());
                dialog.setEverythingLoaded(true);
            }
        };
        if (taskDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/ShowRecentInDialogTask", "createUpdateDialogTask"));
        }
        return taskDescriptor;
    }
}

