/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.rollback;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopy;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.rollback.ChangesAfterPathComparator;
import org.jetbrains.idea.svn.rollback.ChangesChecker;
import org.jetbrains.idea.svn.rollback.Reverter;
import org.jetbrains.idea.svn.rollback.UnversionedAndNotTouchedFilesGroupCollector;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnRollbackEnvironment
extends DefaultRollbackEnvironment {
    private final SvnVcs mySvnVcs;

    public SvnRollbackEnvironment(SvnVcs svnVcs) {
        this.mySvnVcs = svnVcs;
    }

    public String getRollbackOperationName() {
        return SvnBundle.message("action.name.revert", new Object[0]);
    }

    public void rollbackChanges(@NotNull List<Change> changes, @NotNull List<VcsException> exceptions, @NotNull RollbackProgressListener listener) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment", "rollbackChanges"));
        }
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment", "rollbackChanges"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment", "rollbackChanges"));
        }
        listener.indeterminate();
        for (Collection collection : SvnUtil.splitChangesIntoWc(this.mySvnVcs, changes).values()) {
            List sortedChanges = ContainerUtil.sorted((Collection)collection, (Comparator)ChangesAfterPathComparator.getInstance());
            this.rollbackGroupForWc(sortedChanges, exceptions, listener);
        }
    }

    private void rollbackGroupForWc(@NotNull List<Change> changes, @NotNull List<VcsException> exceptions, @NotNull RollbackProgressListener listener) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment", "rollbackGroupForWc"));
        }
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment", "rollbackGroupForWc"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment", "rollbackGroupForWc"));
        }
        UnversionedAndNotTouchedFilesGroupCollector collector = new UnversionedAndNotTouchedFilesGroupCollector();
        ChangesChecker checker = new ChangesChecker(this.mySvnVcs, collector);
        checker.gather(changes);
        exceptions.addAll(checker.getExceptions());
        Reverter reverter = new Reverter(this.mySvnVcs, listener, exceptions);
        reverter.moveRenamesToTmp(collector);
        reverter.revert(checker.getForAdds(), true);
        reverter.revert(checker.getForDeletes(), true);
        reverter.revert(checker.getForEdits(), false);
        reverter.moveGroup();
        for (Couple<File> pair : collector.getToBeDeleted()) {
            if (!((File)pair.getFirst()).exists()) continue;
            FileUtil.delete((File)((File)pair.getSecond()));
        }
    }

    public void rollbackMissingFileDeletion(@NotNull List<FilePath> filePaths, @NotNull List<VcsException> exceptions, @NotNull RollbackProgressListener listener) {
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment", "rollbackMissingFileDeletion"));
        }
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment", "rollbackMissingFileDeletion"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment", "rollbackMissingFileDeletion"));
        }
        for (FilePath filePath : filePaths) {
            listener.accept(filePath);
            try {
                this.revertFileOrDir(filePath);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
            catch (SVNException e) {
                exceptions.add(new VcsException((Throwable)e));
            }
        }
    }

    private void revertFileOrDir(@NotNull FilePath filePath) throws SVNException, VcsException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment", "revertFileOrDir"));
        }
        File file = filePath.getIOFile();
        Info info = this.mySvnVcs.getInfo(file);
        if (info != null) {
            if (info.isFile()) {
                this.doRevert(file, false);
            } else if ("add".equals(info.getSchedule()) || this.is17OrGreaterCopy(file, info)) {
                this.doRevert(file, true);
            } else {
                this.mySvnVcs.getSvnKitManager().createUpdateClient().doUpdate(file, SVNRevision.HEAD, true);
            }
        } else {
            throw new VcsException("Can not get 'svn info' for " + file.getPath());
        }
    }

    private void doRevert(@NotNull File path, boolean recursive) throws VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment", "doRevert"));
        }
        this.mySvnVcs.getFactory(path).createRevertClient().revert(Collections.singletonList(path), Depth.allOrFiles(recursive), null);
    }

    private boolean is17OrGreaterCopy(@NotNull File file, @NotNull Info info) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment", "is17OrGreaterCopy"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment", "is17OrGreaterCopy"));
        }
        WorkingCopy copy = this.mySvnVcs.getRootsToWorkingCopies().getMatchingCopy(info.getURL());
        return copy != null ? copy.is17Copy() : this.mySvnVcs.getWorkingCopyFormat(file).isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN);
    }

    public static boolean isMoveRenameReplace(@NotNull Change c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment", "isMoveRenameReplace"));
        }
        if (c.getAfterRevision() == null || c.getBeforeRevision() == null) {
            return false;
        }
        return c.isIsReplaced() || c.isMoved() || c.isRenamed() || !Comparing.equal((Object)c.getBeforeRevision().getFile(), (Object)c.getAfterRevision().getFile());
    }
}

