/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.codehaus.groovy.ast.ClassNode;
import org.gradle.api.Action;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.internal.plugins.PluginAwareInternal;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectScript;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.BasicScript;
import org.gradle.groovy.scripts.ScriptAware;
import org.gradle.groovy.scripts.ScriptCompiler;
import org.gradle.groovy.scripts.ScriptCompilerFactory;
import org.gradle.groovy.scripts.ScriptRunner;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.Transformer;
import org.gradle.groovy.scripts.internal.BuildScriptTransformer;
import org.gradle.groovy.scripts.internal.FactoryBackedCompileOperation;
import org.gradle.groovy.scripts.internal.InitialPassStatementTransformer;
import org.gradle.groovy.scripts.internal.SubsetScriptTransformer;
import org.gradle.internal.Actions;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.model.dsl.internal.transform.ClosureCreationInterceptingVerifier;
import org.gradle.model.dsl.internal.transform.ModelBlockTransformer;
import org.gradle.model.internal.inspect.ModelRuleSourceDetector;
import org.gradle.plugin.use.internal.PluginRequestApplicator;
import org.gradle.plugin.use.internal.PluginRequests;
import org.gradle.plugin.use.internal.PluginRequestsSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptPluginFactory
implements ScriptPluginFactory {
    private final ScriptCompilerFactory scriptCompilerFactory;
    private final Factory<LoggingManagerInternal> loggingManagerFactory;
    private final Instantiator instantiator;
    private final ScriptHandlerFactory scriptHandlerFactory;
    private final PluginRequestApplicator pluginRequestApplicator;
    private final FileLookup fileLookup;
    private final DocumentationRegistry documentationRegistry;
    private final ModelRuleSourceDetector modelRuleSourceDetector;

    public DefaultScriptPluginFactory(ScriptCompilerFactory scriptCompilerFactory, Factory<LoggingManagerInternal> loggingManagerFactory, Instantiator instantiator, ScriptHandlerFactory scriptHandlerFactory, PluginRequestApplicator pluginRequestApplicator, FileLookup fileLookup, DocumentationRegistry documentationRegistry, ModelRuleSourceDetector modelRuleSourceDetector) {
        this.scriptCompilerFactory = scriptCompilerFactory;
        this.loggingManagerFactory = loggingManagerFactory;
        this.instantiator = instantiator;
        this.scriptHandlerFactory = scriptHandlerFactory;
        this.pluginRequestApplicator = pluginRequestApplicator;
        this.fileLookup = fileLookup;
        this.documentationRegistry = documentationRegistry;
        this.modelRuleSourceDetector = modelRuleSourceDetector;
    }

    @Override
    public ScriptPlugin create(ScriptSource scriptSource, ScriptHandler scriptHandler, ClassLoaderScope targetScope, ClassLoaderScope baseScope, String classpathClosureName, Class<? extends BasicScript> scriptClass, boolean ownerScript) {
        return new ScriptPluginImpl(scriptSource, (ScriptHandlerInternal)scriptHandler, targetScope, baseScope, classpathClosureName, scriptClass, ownerScript);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScriptPluginImpl
    implements ScriptPlugin {
        private final ScriptSource scriptSource;
        private final ClassLoaderScope targetScope;
        private final ClassLoaderScope baseScope;
        private final String classpathClosureName;
        private final Class<? extends BasicScript> scriptType;
        private final ScriptHandlerInternal scriptHandler;
        private final boolean ownerScript;

        public ScriptPluginImpl(ScriptSource scriptSource, ScriptHandlerInternal scriptHandler, ClassLoaderScope targetScope, ClassLoaderScope baseScope, String classpathClosureName, Class<? extends BasicScript> scriptType, boolean ownerScript) {
            this.scriptSource = scriptSource;
            this.targetScope = targetScope;
            this.baseScope = baseScope;
            this.classpathClosureName = classpathClosureName;
            this.scriptHandler = scriptHandler;
            this.scriptType = scriptType;
            this.ownerScript = ownerScript;
        }

        @Override
        public ScriptSource getSource() {
            return this.scriptSource;
        }

        @Override
        public void apply(final Object target) {
            final DefaultServiceRegistry services = new DefaultServiceRegistry();
            services.add(ScriptPluginFactory.class, (Object)DefaultScriptPluginFactory.this);
            services.add(ScriptHandlerFactory.class, (Object)DefaultScriptPluginFactory.this.scriptHandlerFactory);
            services.add(ClassLoaderScope.class, (Object)this.targetScope);
            services.add(LoggingManagerInternal.class, DefaultScriptPluginFactory.this.loggingManagerFactory.create());
            services.add(Instantiator.class, (Object)DefaultScriptPluginFactory.this.instantiator);
            services.add(ScriptHandler.class, (Object)this.scriptHandler);
            services.add(FileLookup.class, (Object)DefaultScriptPluginFactory.this.fileLookup);
            services.add(ModelRuleSourceDetector.class, (Object)DefaultScriptPluginFactory.this.modelRuleSourceDetector);
            ScriptCompiler compiler = DefaultScriptPluginFactory.this.scriptCompilerFactory.createCompiler(this.scriptSource);
            boolean supportsPluginsBlock = ProjectScript.class.isAssignableFrom(this.scriptType);
            String onPluginBlockError = supportsPluginsBlock ? null : "Only Project build scripts can contain plugins {} blocks";
            InitialPassStatementTransformer initialPassStatementTransformer = new InitialPassStatementTransformer(this.classpathClosureName, onPluginBlockError, this.scriptSource, DefaultScriptPluginFactory.this.documentationRegistry);
            SubsetScriptTransformer initialTransformer = new SubsetScriptTransformer(initialPassStatementTransformer);
            FactoryBackedCompileOperation<PluginRequests> initialOperation = new FactoryBackedCompileOperation<PluginRequests>(this.classpathClosureName, (Transformer)initialTransformer, initialPassStatementTransformer, PluginRequestsSerializer.INSTANCE);
            ScriptRunner<? extends BasicScript, PluginRequests> initialRunner = compiler.compile(this.scriptType, initialOperation, this.baseScope.getExportClassLoader(), this.classpathClosureName, (Action<? super ClassNode>)Actions.doNothing());
            initialRunner.getScript().init(target, (ServiceRegistry)services);
            initialRunner.run();
            PluginRequests pluginRequests = initialRunner.getCompiledScript().getData();
            PluginManagerInternal pluginManager = target instanceof PluginAwareInternal ? ((PluginAwareInternal)target).getPluginManager() : null;
            DefaultScriptPluginFactory.this.pluginRequestApplicator.applyPlugins(pluginRequests, this.scriptHandler, pluginManager, this.targetScope);
            BuildScriptTransformer buildScriptTransformer = new BuildScriptTransformer(this.classpathClosureName, this.scriptSource);
            String operationId = "no_" + this.classpathClosureName;
            if (ModelBlockTransformer.isEnabled()) {
                operationId = "m_".concat(operationId);
            }
            FactoryBackedCompileOperation<Boolean> operation = new FactoryBackedCompileOperation<Boolean>(operationId, buildScriptTransformer, buildScriptTransformer, BaseSerializerFactory.BOOLEAN_SERIALIZER);
            final ScriptRunner<? extends BasicScript, Boolean> runner = compiler.compile(this.scriptType, operation, this.targetScope.getLocalClassLoader(), this.classpathClosureName, (Action<? super ClassNode>)ClosureCreationInterceptingVerifier.INSTANCE);
            Runnable buildScriptRunner = new Runnable(){

                public void run() {
                    BasicScript script = (BasicScript)runner.getScript();
                    script.init(target, (ServiceRegistry)services);
                    if (ScriptPluginImpl.this.ownerScript && target instanceof ScriptAware) {
                        ((ScriptAware)target).setScript(script);
                    }
                    runner.run();
                }
            };
            Boolean hasImperativeStatements = runner.getCompiledScript().getData();
            if (!hasImperativeStatements.booleanValue() && target instanceof ProjectInternal) {
                ((ProjectInternal)target).addDeferredConfiguration(buildScriptRunner);
            } else {
                buildScriptRunner.run();
            }
        }
    }
}

