/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import org.gradle.api.GradleScriptException;
import org.gradle.groovy.scripts.Script;
import org.gradle.groovy.scripts.ScriptExecutionListener;
import org.gradle.groovy.scripts.ScriptRunner;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.CompiledScript;
import org.gradle.groovy.scripts.internal.ScriptRunnerFactory;
import org.gradle.internal.reflect.Instantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptRunnerFactory
implements ScriptRunnerFactory {
    private final ScriptExecutionListener listener;
    private final Instantiator instantiator;

    public DefaultScriptRunnerFactory(ScriptExecutionListener listener, Instantiator instantiator) {
        this.listener = listener;
        this.instantiator = instantiator;
    }

    @Override
    public <T extends Script, M> ScriptRunner<T, M> create(CompiledScript<T, M> script, ScriptSource source, ClassLoader contextClassLoader) {
        return new ScriptRunnerImpl<T, M>(script, source, contextClassLoader);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScriptRunnerImpl<T extends Script, M>
    implements ScriptRunner<T, M> {
        private final ScriptSource source;
        private final ClassLoader contextClassLoader;
        private T script;
        private final CompiledScript<T, M> compiledScript;

        public ScriptRunnerImpl(CompiledScript<T, M> compiledScript, ScriptSource source, ClassLoader contextClassLoader) {
            this.compiledScript = compiledScript;
            this.source = source;
            this.contextClassLoader = contextClassLoader;
        }

        @Override
        public T getScript() {
            if (this.script == null) {
                this.script = (Script)((Object)DefaultScriptRunnerFactory.this.instantiator.newInstance(this.compiledScript.loadClass(), new Object[0]));
                ((Script)((Object)this.script)).setScriptSource(this.source);
                ((Script)((Object)this.script)).setContextClassloader(this.contextClassLoader);
            }
            return this.script;
        }

        @Override
        public CompiledScript<T, M> getCompiledScript() {
            return this.compiledScript;
        }

        @Override
        public void run() throws GradleScriptException {
            ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
            groovy.lang.Script script = this.getScript();
            DefaultScriptRunnerFactory.this.listener.beforeScript((Script)script);
            GradleScriptException failure = null;
            Thread.currentThread().setContextClassLoader(script.getContextClassloader());
            script.getStandardOutputCapture().start();
            try {
                script.run();
            }
            catch (Throwable e) {
                failure = new GradleScriptException(String.format("A problem occurred evaluating %s.", script), e);
            }
            script.getStandardOutputCapture().stop();
            Thread.currentThread().setContextClassLoader(originalLoader);
            DefaultScriptRunnerFactory.this.listener.afterScript((Script)script, (Throwable)((Object)failure));
            if (failure != null) {
                throw failure;
            }
        }
    }
}

