/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunManager {
    public static RunManager getInstance(Project project) {
        return project.getComponent(RunManager.class);
    }

    @NotNull
    public abstract ConfigurationType[] getConfigurationFactories();

    @Deprecated
    @NotNull
    public abstract RunConfiguration[] getConfigurations(@NotNull ConfigurationType var1);

    @NotNull
    public abstract List<RunConfiguration> getConfigurationsList(@NotNull ConfigurationType var1);

    @Deprecated
    @NotNull
    public abstract RunnerAndConfigurationSettings[] getConfigurationSettings(@NotNull ConfigurationType var1);

    @NotNull
    public abstract List<RunnerAndConfigurationSettings> getConfigurationSettingsList(@NotNull ConfigurationType var1);

    @Deprecated
    @NotNull
    public abstract RunConfiguration[] getAllConfigurations();

    @NotNull
    public abstract List<RunConfiguration> getAllConfigurationsList();

    @NotNull
    public abstract List<RunnerAndConfigurationSettings> getAllSettings();

    @Deprecated
    @NotNull
    public abstract RunConfiguration[] getTempConfigurations();

    @NotNull
    public abstract List<RunnerAndConfigurationSettings> getTempConfigurationsList();

    @Deprecated
    public abstract boolean isTemporary(@NotNull RunConfiguration var1);

    @Deprecated
    public abstract void makeStable(@NotNull RunConfiguration var1);

    public abstract void makeStable(@NotNull RunnerAndConfigurationSettings var1);

    @Nullable
    public abstract RunnerAndConfigurationSettings getSelectedConfiguration();

    public abstract void setSelectedConfiguration(@Nullable RunnerAndConfigurationSettings var1);

    @NotNull
    public abstract RunnerAndConfigurationSettings createRunConfiguration(@NotNull String var1, @NotNull ConfigurationFactory var2);

    @NotNull
    public abstract RunnerAndConfigurationSettings createConfiguration(@NotNull RunConfiguration var1, @NotNull ConfigurationFactory var2);

    @NotNull
    public abstract RunnerAndConfigurationSettings getConfigurationTemplate(ConfigurationFactory var1);

    public abstract void addConfiguration(RunnerAndConfigurationSettings var1, boolean var2);

    public abstract void refreshUsagesList(RunProfile var1);

    @NotNull
    public static String suggestUniqueName(@NotNull String str, @NotNull Collection<String> currentNames) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/execution/RunManager", "suggestUniqueName"));
        }
        if (currentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentNames", "com/intellij/execution/RunManager", "suggestUniqueName"));
        }
        if (!currentNames.contains(str)) {
            String string = str;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/RunManager", "suggestUniqueName"));
            }
            return string;
        }
        Matcher matcher = Pattern.compile("(.*?)\\s*\\(\\d+\\)").matcher(str);
        String originalName = matcher.matches() ? matcher.group(1) : str;
        int i = 1;
        while (true) {
            String newName;
            if (!currentNames.contains(newName = String.format("%s (%d)", originalName, i))) {
                String string = newName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/RunManager", "suggestUniqueName"));
                }
                return string;
            }
            ++i;
        }
    }
}

