/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Computable;

public class CommandLineBuilder {
    private CommandLineBuilder() {
    }

    public static GeneralCommandLine createFromJavaParameters(SimpleJavaParameters javaParameters) throws CantRunException {
        return CommandLineBuilder.createFromJavaParameters(javaParameters, false);
    }

    public static GeneralCommandLine createFromJavaParameters(SimpleJavaParameters javaParameters, Project project, boolean dynamicClasspath) throws CantRunException {
        return CommandLineBuilder.createFromJavaParameters(javaParameters, dynamicClasspath && JdkUtil.useDynamicClasspath(project));
    }

    public static GeneralCommandLine createFromJavaParameters(final SimpleJavaParameters javaParameters, final boolean forceDynamicClasspath) throws CantRunException {
        try {
            return ApplicationManager.getApplication().runReadAction(new Computable<GeneralCommandLine>(){

                public GeneralCommandLine compute() {
                    try {
                        Sdk jdk = javaParameters.getJdk();
                        if (jdk == null) {
                            throw new CantRunException(ExecutionBundle.message("run.configuration.error.no.jdk.specified", new Object[0]));
                        }
                        SdkTypeId sdkType = jdk.getSdkType();
                        if (!(sdkType instanceof JavaSdkType)) {
                            throw new CantRunException(ExecutionBundle.message("run.configuration.error.no.jdk.specified", new Object[0]));
                        }
                        String exePath = ((JavaSdkType)((Object)sdkType)).getVMExecutablePath(jdk);
                        if (exePath == null) {
                            throw new CantRunException(ExecutionBundle.message("run.configuration.cannot.find.vm.executable", new Object[0]));
                        }
                        if (javaParameters.getMainClass() == null && javaParameters.getJarPath() == null) {
                            throw new CantRunException(ExecutionBundle.message("main.class.is.not.specified.error.message", new Object[0]));
                        }
                        return JdkUtil.setupJVMCommandLine(exePath, javaParameters, forceDynamicClasspath);
                    }
                    catch (CantRunException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof CantRunException) {
                throw (CantRunException)e.getCause();
            }
            throw e;
        }
    }
}

