/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.autodetecting.FacetDetectorRegistry;
import com.intellij.facet.ui.DefaultFacetSettingsEditor;
import com.intellij.facet.ui.FacetEditor;
import com.intellij.facet.ui.MultipleFacetSettingsEditor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetType<F extends Facet, C extends FacetConfiguration> {
    public static final ExtensionPointName<FacetType> EP_NAME = ExtensionPointName.create((String)"com.intellij.facetType");
    @NotNull
    private final FacetTypeId<F> myId;
    @NotNull
    private final String myStringId;
    @NotNull
    private final String myPresentableName;
    @Nullable
    private final FacetTypeId myUnderlyingFacetType;

    public static <T extends FacetType> T findInstance(Class<T> aClass) {
        return (T)((FacetType)EP_NAME.findExtension(aClass));
    }

    public FacetType(@NotNull FacetTypeId<F> id, @NotNull @NonNls String stringId, @NotNull String presentableName, @Nullable FacetTypeId underlyingFacetType) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/facet/FacetType", "<init>"));
        }
        if (stringId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringId", "com/intellij/facet/FacetType", "<init>"));
        }
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/facet/FacetType", "<init>"));
        }
        this.myId = id;
        this.myStringId = stringId;
        this.myPresentableName = presentableName;
        this.myUnderlyingFacetType = underlyingFacetType;
    }

    public FacetType(@NotNull FacetTypeId<F> id, @NotNull @NonNls String stringId, @NotNull String presentableName) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/facet/FacetType", "<init>"));
        }
        if (stringId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringId", "com/intellij/facet/FacetType", "<init>"));
        }
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/facet/FacetType", "<init>"));
        }
        this(id, stringId, presentableName, null);
    }

    @NotNull
    public final FacetTypeId<F> getId() {
        FacetTypeId<F> facetTypeId = this.myId;
        if (facetTypeId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetType", "getId"));
        }
        return facetTypeId;
    }

    @NotNull
    public final String getStringId() {
        String string = this.myStringId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetType", "getStringId"));
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myPresentableName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetType", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getDefaultFacetName() {
        String string = this.myPresentableName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetType", "getDefaultFacetName"));
        }
        return string;
    }

    @Nullable
    public final FacetTypeId<?> getUnderlyingFacetType() {
        return this.myUnderlyingFacetType;
    }

    public void registerDetectors(FacetDetectorRegistry<C> registry) {
    }

    public abstract C createDefaultConfiguration();

    public abstract F createFacet(@NotNull Module var1, String var2, @NotNull C var3, @Nullable Facet var4);

    public boolean isOnlyOneFacetAllowed() {
        return true;
    }

    public abstract boolean isSuitableModuleType(ModuleType var1);

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public DefaultFacetSettingsEditor createDefaultConfigurationEditor(@NotNull Project project, @NotNull C configuration) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/facet/FacetType", "createDefaultConfigurationEditor"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/facet/FacetType", "createDefaultConfigurationEditor"));
        }
        return null;
    }

    @Nullable
    public MultipleFacetSettingsEditor createMultipleConfigurationsEditor(@NotNull Project project, @NotNull FacetEditor[] editors) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/facet/FacetType", "createMultipleConfigurationsEditor"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/facet/FacetType", "createMultipleConfigurationsEditor"));
        }
        return null;
    }
}

