/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.chrome;

import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.chrome.ChromeSettingsConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChromeSettings
extends BrowserSpecificSettings {
    public static final String USER_DATA_DIR_ARG = "--user-data-dir=";
    @Nullable
    private String myCommandLineOptions;
    @Nullable
    private String myUserDataDirectoryPath;
    private boolean myUseCustomProfile;
    @NotNull
    private Map<String, String> myEnvironmentVariables = new THashMap();

    @Tag(value="user-data-dir")
    @Nullable
    public String getUserDataDirectoryPath() {
        return this.myUserDataDirectoryPath;
    }

    @Tag(value="use-custom-profile")
    public boolean isUseCustomProfile() {
        return this.myUseCustomProfile;
    }

    @Tag(value="command-line-options")
    @Nullable
    public String getCommandLineOptions() {
        return this.myCommandLineOptions;
    }

    public void setCommandLineOptions(@Nullable String value) {
        this.myCommandLineOptions = StringUtil.nullize((String)value);
    }

    public void setUserDataDirectoryPath(@Nullable String value) {
        this.myUserDataDirectoryPath = PathUtil.toSystemIndependentName(StringUtil.nullize((String)value));
    }

    public void setUseCustomProfile(boolean useCustomProfile) {
        this.myUseCustomProfile = useCustomProfile;
    }

    @Override
    @NotNull
    public List<String> getAdditionalParameters() {
        if (this.myCommandLineOptions == null) {
            if (this.myUseCustomProfile && this.myUserDataDirectoryPath != null) {
                List<String> list = Collections.singletonList(USER_DATA_DIR_ARG + FileUtilRt.toSystemDependentName((String)this.myUserDataDirectoryPath));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/chrome/ChromeSettings", "getAdditionalParameters"));
                }
                return list;
            }
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/chrome/ChromeSettings", "getAdditionalParameters"));
            }
            return list;
        }
        List cliOptions = ParametersListUtil.parse((String)this.myCommandLineOptions);
        if (this.myUseCustomProfile && this.myUserDataDirectoryPath != null) {
            cliOptions.add(USER_DATA_DIR_ARG + FileUtilRt.toSystemDependentName((String)this.myUserDataDirectoryPath));
        }
        List list = cliOptions;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/chrome/ChromeSettings", "getAdditionalParameters"));
        }
        return list;
    }

    @Override
    @Tag(value="environment-variables")
    @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false)
    @NotNull
    public Map<String, String> getEnvironmentVariables() {
        Map<String, String> map = this.myEnvironmentVariables;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/chrome/ChromeSettings", "getEnvironmentVariables"));
        }
        return map;
    }

    public void setEnvironmentVariables(@NotNull Map<String, String> environmentVariables) {
        if (environmentVariables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environmentVariables", "com/intellij/ide/browsers/chrome/ChromeSettings", "setEnvironmentVariables"));
        }
        this.myEnvironmentVariables = environmentVariables;
    }

    @Override
    @NotNull
    public ChromeSettingsConfigurable createConfigurable() {
        ChromeSettingsConfigurable chromeSettingsConfigurable = new ChromeSettingsConfigurable(this);
        if (chromeSettingsConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/chrome/ChromeSettings", "createConfigurable"));
        }
        return chromeSettingsConfigurable;
    }

    @Override
    public ChromeSettings clone() {
        ChromeSettings clone = (ChromeSettings)super.clone();
        clone.myEnvironmentVariables = new THashMap(this.myEnvironmentVariables);
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChromeSettings settings = (ChromeSettings)o;
        return this.myUseCustomProfile == settings.myUseCustomProfile && Comparing.equal((String)this.myCommandLineOptions, (String)settings.myCommandLineOptions) && (!this.myUseCustomProfile || Comparing.equal((String)this.myUserDataDirectoryPath, (String)settings.myUserDataDirectoryPath)) && this.myEnvironmentVariables.equals(settings.myEnvironmentVariables);
    }
}

