/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.ide.ui.UISettings;
import org.jetbrains.annotations.NonNls;

public final class ToolWindowAnchor {
    public static final ToolWindowAnchor TOP = new ToolWindowAnchor("top");
    public static final ToolWindowAnchor LEFT = new ToolWindowAnchor("left");
    public static final ToolWindowAnchor BOTTOM = new ToolWindowAnchor("bottom");
    public static final ToolWindowAnchor RIGHT = new ToolWindowAnchor("right");
    private final String myText;

    private ToolWindowAnchor(@NonNls String text) {
        this.myText = text;
    }

    public String toString() {
        return this.myText;
    }

    public boolean isHorizontal() {
        return this == TOP || this == BOTTOM;
    }

    public static ToolWindowAnchor get(int swingOrientationConstant) {
        switch (swingOrientationConstant) {
            case 1: {
                return TOP;
            }
            case 3: {
                return BOTTOM;
            }
            case 2: {
                return LEFT;
            }
            case 4: {
                return RIGHT;
            }
        }
        throw new IllegalArgumentException("Unknown anchor constant: " + swingOrientationConstant);
    }

    public boolean isSplitVertically() {
        return this == LEFT && !UISettings.getInstance().LEFT_HORIZONTAL_SPLIT || this == RIGHT && !UISettings.getInstance().RIGHT_HORIZONTAL_SPLIT;
    }

    public static ToolWindowAnchor fromText(String anchor) {
        for (ToolWindowAnchor a : new ToolWindowAnchor[]{TOP, LEFT, BOTTOM, RIGHT}) {
            if (!a.myText.equals(anchor)) continue;
            return a;
        }
        throw new IllegalArgumentException("Unknown anchor constant: " + anchor);
    }
}

