/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultArrangementEntry
implements ArrangementEntry {
    @NotNull
    private final List<ArrangementEntry> myChildren = new ArrayList<ArrangementEntry>();
    @Nullable
    private final ArrangementEntry myParent;
    @Nullable
    private List<ArrangementEntry> myDependencies;
    private final int myStartOffset;
    private final int myEndOffset;
    private final boolean myCanBeMatched;

    public DefaultArrangementEntry(@Nullable ArrangementEntry parent, int startOffset, int endOffset, boolean canBeMatched) {
        this.myCanBeMatched = canBeMatched;
        assert (startOffset < endOffset);
        this.myParent = parent;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
    }

    @Override
    @Nullable
    public ArrangementEntry getParent() {
        return this.myParent;
    }

    @Override
    @NotNull
    public List<? extends ArrangementEntry> getChildren() {
        List<ArrangementEntry> list = this.myChildren;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementEntry", "getChildren"));
        }
        return list;
    }

    public void addChild(@NotNull ArrangementEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementEntry", "addChild"));
        }
        this.myChildren.add(entry);
    }

    @Override
    @Nullable
    public List<? extends ArrangementEntry> getDependencies() {
        return this.myDependencies;
    }

    public void addDependency(@NotNull ArrangementEntry dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementEntry", "addDependency"));
        }
        if (this.myDependencies == null) {
            this.myDependencies = new ArrayList<ArrangementEntry>();
        }
        this.myDependencies.add(dependency);
    }

    @Override
    public int getStartOffset() {
        return this.myStartOffset;
    }

    @Override
    public int getEndOffset() {
        return this.myEndOffset;
    }

    @Override
    public boolean canBeMatched() {
        return this.myCanBeMatched;
    }
}

