/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.EditableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionListModel<T>
extends AbstractListModel
implements EditableModel {
    private final List<T> myItems;

    public CollectionListModel(@NotNull Collection<? extends T> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/ui/CollectionListModel", "<init>"));
        }
        this.myItems = new ArrayList<T>(items);
    }

    protected CollectionListModel(@NotNull List<T> items, boolean useListAsIs) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/ui/CollectionListModel", "<init>"));
        }
        this.myItems = items;
    }

    public CollectionListModel(@NotNull List<? extends T> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/ui/CollectionListModel", "<init>"));
        }
        this.myItems = new ArrayList<T>(items);
    }

    public CollectionListModel(T ... items) {
        this.myItems = ContainerUtilRt.newArrayList((Object[])items);
    }

    @NotNull
    protected final List<T> getInternalList() {
        List<T> list = this.myItems;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/CollectionListModel", "getInternalList"));
        }
        return list;
    }

    @Override
    public int getSize() {
        return this.myItems.size();
    }

    @Override
    public T getElementAt(int index) {
        return this.myItems.get(index);
    }

    public void add(T element) {
        int i = this.myItems.size();
        this.myItems.add(element);
        this.fireIntervalAdded(this, i, i);
    }

    public void add(int i, T element) {
        this.myItems.add(i, element);
        this.fireIntervalAdded(this, i, i);
    }

    public void add(@NotNull List<? extends T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ui/CollectionListModel", "add"));
        }
        if (elements.isEmpty()) {
            return;
        }
        int i = this.myItems.size();
        this.myItems.addAll(elements);
        this.fireIntervalAdded(this, i, i + elements.size() - 1);
    }

    public void remove(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ui/CollectionListModel", "remove"));
        }
        int index = this.getElementIndex(element);
        if (index != -1) {
            this.remove(index);
        }
    }

    public void setElementAt(@NotNull T item, int index) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/ui/CollectionListModel", "setElementAt"));
        }
        this.itemReplaced(this.myItems.set(index, item), item);
        this.fireContentsChanged(this, index, index);
    }

    protected void itemReplaced(@NotNull T existingItem, @Nullable T newItem) {
        if (existingItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingItem", "com/intellij/ui/CollectionListModel", "itemReplaced"));
        }
    }

    public void remove(int index) {
        this.itemReplaced(this.myItems.remove(index), null);
        this.fireIntervalRemoved(this, index, index);
    }

    public void removeAll() {
        int size = this.myItems.size();
        if (size > 0) {
            this.myItems.clear();
            this.fireIntervalRemoved(this, 0, size - 1);
        }
    }

    public void contentsChanged(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ui/CollectionListModel", "contentsChanged"));
        }
        int i = this.myItems.indexOf(element);
        this.fireContentsChanged(this, i, i);
    }

    public void sort(Comparator<T> comparator) {
        Collections.sort(this.myItems, comparator);
    }

    @NotNull
    public List<T> getItems() {
        List<T> list = Collections.unmodifiableList(this.myItems);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/CollectionListModel", "getItems"));
        }
        return list;
    }

    public void replaceAll(@NotNull List<? extends T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ui/CollectionListModel", "replaceAll"));
        }
        this.removeAll();
        this.add(elements);
    }

    public void addRow() {
    }

    public void removeRow(int index) {
        this.remove(index);
    }

    public void exchangeRows(int oldIndex, int newIndex) {
        Collections.swap(this.myItems, oldIndex, newIndex);
        this.fireContentsChanged(this, oldIndex, oldIndex);
        this.fireContentsChanged(this, newIndex, newIndex);
    }

    public boolean canExchangeRows(int oldIndex, int newIndex) {
        return true;
    }

    @NonNls
    public String toString() {
        return this.getClass().getName() + " (" + this.getSize() + " elements)";
    }

    public List<T> toList() {
        return new ArrayList<T>(this.myItems);
    }

    public int getElementIndex(T item) {
        return this.myItems.indexOf(item);
    }

    public boolean isEmpty() {
        return this.myItems.isEmpty();
    }
}

