/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.AnchorableComponent;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBLabel
extends JLabel
implements AnchorableComponent {
    private UIUtil.ComponentStyle myComponentStyle;
    private UIUtil.FontColor myFontColor;
    private JComponent myAnchor;

    public JBLabel() {
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAnchor = null;
    }

    public JBLabel(@NotNull UIUtil.ComponentStyle componentStyle) {
        if (componentStyle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentStyle", "com/intellij/ui/components/JBLabel", "<init>"));
        }
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAnchor = null;
        this.setComponentStyle(componentStyle);
    }

    public JBLabel(@Nullable Icon image) {
        super(image);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAnchor = null;
    }

    public JBLabel(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/components/JBLabel", "<init>"));
        }
        super(text);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAnchor = null;
    }

    public JBLabel(@NotNull String text, @NotNull UIUtil.ComponentStyle componentStyle) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/components/JBLabel", "<init>"));
        }
        if (componentStyle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentStyle", "com/intellij/ui/components/JBLabel", "<init>"));
        }
        super(text);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAnchor = null;
        this.setComponentStyle(componentStyle);
    }

    public JBLabel(@NotNull String text, @NotNull UIUtil.ComponentStyle componentStyle, @NotNull UIUtil.FontColor fontColor) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/components/JBLabel", "<init>"));
        }
        if (componentStyle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentStyle", "com/intellij/ui/components/JBLabel", "<init>"));
        }
        if (fontColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontColor", "com/intellij/ui/components/JBLabel", "<init>"));
        }
        super(text);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAnchor = null;
        this.setComponentStyle(componentStyle);
        this.setFontColor(fontColor);
    }

    public JBLabel(@NotNull String text, @JdkConstants.HorizontalAlignment int horizontalAlignment) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/components/JBLabel", "<init>"));
        }
        super(text, horizontalAlignment);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAnchor = null;
    }

    public JBLabel(@Nullable Icon image, @JdkConstants.HorizontalAlignment int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAnchor = null;
    }

    public JBLabel(@NotNull String text, @Nullable Icon icon, @JdkConstants.HorizontalAlignment int horizontalAlignment) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/components/JBLabel", "<init>"));
        }
        super(text, icon, horizontalAlignment);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAnchor = null;
    }

    public void setComponentStyle(@NotNull UIUtil.ComponentStyle componentStyle) {
        if (componentStyle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentStyle", "com/intellij/ui/components/JBLabel", "setComponentStyle"));
        }
        this.myComponentStyle = componentStyle;
        UIUtil.applyStyle((UIUtil.ComponentStyle)componentStyle, (Component)this);
    }

    public UIUtil.ComponentStyle getComponentStyle() {
        return this.myComponentStyle;
    }

    public UIUtil.FontColor getFontColor() {
        return this.myFontColor;
    }

    public void setFontColor(@NotNull UIUtil.FontColor fontColor) {
        if (fontColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontColor", "com/intellij/ui/components/JBLabel", "setFontColor"));
        }
        this.myFontColor = fontColor;
    }

    @Override
    public Color getForeground() {
        if (!this.isEnabled()) {
            return UIUtil.getLabelDisabledForeground();
        }
        if (this.myFontColor != null) {
            return UIUtil.getLabelFontColor((UIUtil.FontColor)this.myFontColor);
        }
        return super.getForeground();
    }

    @Override
    public void setForeground(Color fg) {
        this.myFontColor = null;
        super.setForeground(fg);
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myAnchor == null || this.myAnchor == this ? super.getPreferredSize() : this.myAnchor.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.myAnchor == null || this.myAnchor == this ? super.getMinimumSize() : this.myAnchor.getMinimumSize();
    }
}

