/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.proxy;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.util.proxy.NonStaticAuthenticator;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonProxy
extends ProxySelector {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.proxy.CommonProxy");
    private static final CommonProxy ourInstance = new CommonProxy();
    private final CommonAuthenticator myAuthenticator = new CommonAuthenticator();
    private static final ThreadLocal<Boolean> ourReenterDefence = new ThreadLocal();
    public static final List<Proxy> NO_PROXY_LIST = Collections.singletonList(Proxy.NO_PROXY);
    private static final long ourErrorInterval = TimeUnit.MINUTES.toMillis(3L);
    private static volatile int ourNotificationCount;
    private static volatile long ourErrorTime;
    private static volatile ProxySelector ourWrong;
    private static final AtomicReference<Map<String, String>> ourProps;
    private final Object myLock = new Object();
    private final Set<Pair<HostInfo, Thread>> myNoProxy = new THashSet();
    private final Map<String, ProxySelector> myCustom = new THashMap();
    private final Map<String, NonStaticAuthenticator> myCustomAuth = new THashMap();

    public static CommonProxy getInstance() {
        return ourInstance;
    }

    private CommonProxy() {
        this.ensureAuthenticator();
    }

    public static void isInstalledAssertion() {
        ProxySelector aDefault = ProxySelector.getDefault();
        if (ourInstance != aDefault) {
            if (ourWrong != aDefault || CommonProxy.itsTime()) {
                LOG.error("ProxySelector.setDefault() was changed to [" + aDefault.toString() + "] - other than com.intellij.util.proxy.CommonProxy.ourInstance.\n" + "This will make some " + ApplicationNamesInfo.getInstance().getProductName() + " network calls fail.\n" + "Instead, methods of com.intellij.util.proxy.CommonProxy should be used for proxying.");
                ourWrong = aDefault;
            }
            ProxySelector.setDefault(ourInstance);
            ourInstance.ensureAuthenticator();
        }
        CommonProxy.assertSystemPropertiesSet();
    }

    private static boolean itsTime() {
        boolean b;
        boolean bl = b = System.currentTimeMillis() - ourErrorTime > ourErrorInterval && ourNotificationCount < 5;
        if (b) {
            ourErrorTime = System.currentTimeMillis();
            ++ourNotificationCount;
        }
        return b;
    }

    private static void assertSystemPropertiesSet() {
        Map<String, String> props = CommonProxy.getOldStyleProperties();
        Map<String, String> was = ourProps.get();
        if (Comparing.equal(was, props) && !CommonProxy.itsTime()) {
            return;
        }
        ourProps.set(props);
        String message = CommonProxy.getMessageFromProps(props);
        if (message != null) {
            LOG.info(message);
        }
    }

    @Nullable
    public static String getMessageFromProps(Map<String, String> props) {
        String message = null;
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (StringUtil.isEmptyOrSpaces((String)entry.getValue())) continue;
            message = CommonBundle.message((String)"label.old.way.jvm.property.used", (Object[])new Object[]{entry.getKey(), entry.getValue()});
            break;
        }
        return message;
    }

    public static Map<String, String> getOldStyleProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("http.proxyHost", System.getProperty("http.proxyHost"));
        props.put("https.proxyHost", System.getProperty("https.proxyHost"));
        props.put("socksProxyHost", System.getProperty("socksProxyHost"));
        return props;
    }

    public void ensureAuthenticator() {
        Authenticator.setDefault(this.myAuthenticator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noProxy(@NotNull String protocol, @NotNull String host, int port) {
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/util/proxy/CommonProxy", "noProxy"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/proxy/CommonProxy", "noProxy"));
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("no proxy added: " + protocol + "://" + host + ":" + port);
            this.myNoProxy.add((Pair<HostInfo, Thread>)Pair.create((Object)new HostInfo(protocol, host, port), (Object)Thread.currentThread()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNoProxy(@NotNull String protocol, @NotNull String host, int port) {
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/util/proxy/CommonProxy", "removeNoProxy"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/proxy/CommonProxy", "removeNoProxy"));
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("no proxy removed: " + protocol + "://" + host + ":" + port);
            this.myNoProxy.remove(Pair.create((Object)new HostInfo(protocol, host, port), (Object)Thread.currentThread()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noAuthentication(@NotNull String protocol, @NotNull String host, int port) {
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/util/proxy/CommonProxy", "noAuthentication"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/proxy/CommonProxy", "noAuthentication"));
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("no proxy added: " + protocol + "://" + host + ":" + port);
            this.myNoProxy.add((Pair<HostInfo, Thread>)Pair.create((Object)new HostInfo(protocol, host, port), (Object)Thread.currentThread()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNoAuthentication(@NotNull String protocol, @NotNull String host, int port) {
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/util/proxy/CommonProxy", "removeNoAuthentication"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/proxy/CommonProxy", "removeNoAuthentication"));
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("no proxy removed: " + protocol + "://" + host + ":" + port);
            this.myNoProxy.remove(Pair.create((Object)new HostInfo(protocol, host, port), (Object)Thread.currentThread()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustom(@NotNull String key, @NotNull ProxySelector proxySelector) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/proxy/CommonProxy", "setCustom"));
        }
        if (proxySelector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxySelector", "com/intellij/util/proxy/CommonProxy", "setCustom"));
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("custom set: " + key + ", " + proxySelector.toString());
            this.myCustom.put(key, proxySelector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomAuth(@NotNull String key, NonStaticAuthenticator authenticator) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/proxy/CommonProxy", "setCustomAuth"));
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("custom auth set: " + key + ", " + authenticator.toString());
            this.myCustomAuth.put(key, authenticator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomAuth(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/proxy/CommonProxy", "removeCustomAuth"));
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("custom auth removed: " + key);
            this.myCustomAuth.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustom(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/proxy/CommonProxy", "removeCustom"));
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("custom set: " + key);
            this.myCustom.remove(key);
        }
    }

    public List<Proxy> select(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/proxy/CommonProxy", "select"));
        }
        return this.select(CommonProxy.createUri(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Proxy> select(@Nullable URI uri) {
        CommonProxy.isInstalledAssertion();
        if (uri == null) {
            return NO_PROXY_LIST;
        }
        LOG.debug("CommonProxy.select called for " + uri.toString());
        if (Boolean.TRUE.equals(ourReenterDefence.get())) {
            return NO_PROXY_LIST;
        }
        try {
            THashMap copy;
            ourReenterDefence.set(Boolean.TRUE);
            String host = StringUtil.notNullize((String)uri.getHost());
            if (NetUtils.isLocalhost(host)) {
                List<Proxy> list = NO_PROXY_LIST;
                return list;
            }
            HostInfo info = new HostInfo(uri.getScheme(), host, CommonProxy.correctPortByProtocol(uri));
            Object object = this.myLock;
            synchronized (object) {
                block14: {
                    if (!this.myNoProxy.contains(Pair.create((Object)info, (Object)Thread.currentThread()))) break block14;
                    LOG.debug("CommonProxy.select returns no proxy (in no proxy list) for " + uri.toString());
                    List<Proxy> list = NO_PROXY_LIST;
                    return list;
                }
                copy = new THashMap(this.myCustom);
            }
            for (Map.Entry entry : copy.entrySet()) {
                List<Proxy> proxies = ((ProxySelector)entry.getValue()).select(uri);
                if (ContainerUtil.isEmpty(proxies)) continue;
                LOG.debug("CommonProxy.select returns custom proxy for " + uri.toString() + ", " + proxies.toString());
                List<Proxy> list = proxies;
                return list;
            }
            object = NO_PROXY_LIST;
            return object;
        }
        finally {
            ourReenterDefence.remove();
        }
    }

    private static int correctPortByProtocol(@NotNull URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/intellij/util/proxy/CommonProxy", "correctPortByProtocol"));
        }
        if (uri.getPort() == -1) {
            if ("http".equals(uri.getScheme())) {
                return 80;
            }
            if ("https".equals(uri.getScheme())) {
                return 443;
            }
        }
        return uri.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        THashMap copy;
        LOG.info("connect failed to " + uri.toString() + ", sa: " + sa.toString(), (Throwable)ioe);
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            copy = new THashMap(this.myCustom);
        }
        for (Map.Entry entry : copy.entrySet()) {
            ((ProxySelector)entry.getValue()).connectFailed(uri, sa, ioe);
        }
    }

    public static String getHostNameReliably(String requestingHost, InetAddress site, URL requestingUrl) {
        String host = requestingHost;
        if (host == null) {
            if (site != null) {
                host = site.getHostName();
            } else if (requestingUrl != null) {
                host = requestingUrl.getHost();
            }
        }
        host = host == null ? "" : host;
        return host;
    }

    private static URI createUri(URL url) {
        return VfsUtil.toUri(url.toString());
    }

    static {
        ourErrorTime = 0L;
        ourProps = new AtomicReference();
        ProxySelector.setDefault(ourInstance);
    }

    public static class HostInfo {
        public final String myProtocol;
        public final String myHost;
        public final int myPort;

        public HostInfo(@Nullable String protocol, @NotNull String host, int port) {
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/proxy/CommonProxy$HostInfo", "<init>"));
            }
            this.myPort = port;
            this.myHost = host;
            this.myProtocol = protocol;
        }

        public String getProtocol() {
            return this.myProtocol;
        }

        public String getHost() {
            return this.myHost;
        }

        public int getPort() {
            return this.myPort;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HostInfo info = (HostInfo)o;
            return this.myPort == info.myPort && this.myHost.equals(info.myHost) && Comparing.equal((String)this.myProtocol, (String)info.myProtocol);
        }

        public int hashCode() {
            int result = this.myProtocol != null ? this.myProtocol.hashCode() : 0;
            result = 31 * result + this.myHost.hashCode();
            result = 31 * result + this.myPort;
            return result;
        }
    }

    private class CommonAuthenticator
    extends Authenticator {
        private CommonAuthenticator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            HashMap copy;
            String siteStr = this.getRequestingSite() == null ? null : this.getRequestingSite().toString();
            LOG.debug("CommonAuthenticator.getPasswordAuthentication called for " + siteStr);
            String host = CommonProxy.getHostNameReliably(this.getRequestingHost(), this.getRequestingSite(), this.getRequestingURL());
            int port = this.getRequestingPort();
            Iterator iterator = CommonProxy.this.myLock;
            synchronized (iterator) {
                HostInfo hostInfo = new HostInfo(this.getRequestingProtocol(), host, port);
                Pair pair = Pair.create((Object)hostInfo, (Object)Thread.currentThread());
                if (CommonProxy.this.myNoProxy.contains(pair)) {
                    LOG.debug("CommonAuthenticator.getPasswordAuthentication found host in no proxies set (" + siteStr + ")");
                    return null;
                }
                copy = new HashMap(CommonProxy.this.myCustomAuth);
            }
            if (!copy.isEmpty()) {
                for (Map.Entry entry : copy.entrySet()) {
                    NonStaticAuthenticator authenticator = (NonStaticAuthenticator)entry.getValue();
                    this.prepareAuthenticator(authenticator);
                    PasswordAuthentication authentication = authenticator.getPasswordAuthentication();
                    if (authentication == null) continue;
                    LOG.debug("CommonAuthenticator.getPasswordAuthentication found custom authenticator for " + siteStr + ", " + (String)entry.getKey() + ", " + authenticator.toString());
                    this.logAuthentication(authentication);
                    return authentication;
                }
            }
            return null;
        }

        private void prepareAuthenticator(NonStaticAuthenticator authenticator) {
            authenticator.setRequestingHost(this.getRequestingHost());
            authenticator.setRequestingSite(this.getRequestingSite());
            authenticator.setRequestingPort(this.getRequestingPort());
            authenticator.setRequestingProtocol(this.getRequestingProtocol());
            authenticator.setRequestingPrompt(this.getRequestingPrompt());
            authenticator.setRequestingScheme(this.getRequestingScheme());
            authenticator.setRequestingURL(this.getRequestingURL());
            authenticator.setRequestorType(this.getRequestorType());
        }

        private void logAuthentication(PasswordAuthentication authentication) {
            if (authentication == null) {
                LOG.debug("CommonAuthenticator.getPasswordAuthentication returned null");
            } else {
                LOG.debug("CommonAuthenticator.getPasswordAuthentication returned authentication pair with login: " + authentication.getUserName());
            }
        }
    }
}

