/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.theoryinpractice.testng.util.TestNGUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitConvertTool
extends BaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"TestNG QuickFix");
    private static final String DISPLAY_NAME = "Convert JUnit Tests to TestNG";
    public static final String QUICKFIX_NAME = "Convert TestCase to TestNG";

    @NotNull
    public String getGroupDisplayName() {
        if ("TestNG" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/JUnitConvertTool", "getGroupDisplayName"));
        }
        return "TestNG";
    }

    @NotNull
    public String getDisplayName() {
        if (DISPLAY_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/JUnitConvertTool", "getDisplayName"));
        }
        return DISPLAY_NAME;
    }

    @NotNull
    public String getShortName() {
        if ("JUnitTestNG" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/JUnitConvertTool", "getShortName"));
        }
        return "JUnitTestNG";
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/theoryinpractice/testng/inspection/JUnitConvertTool", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/theoryinpractice/testng/inspection/JUnitConvertTool", "checkClass"));
        }
        if (TestNGUtil.inheritsJUnitTestCase(psiClass) || TestNGUtil.containsJunitAnnotions(psiClass)) {
            PsiIdentifier nameIdentifier = psiClass.getNameIdentifier();
            ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)(nameIdentifier != null ? nameIdentifier : psiClass), "TestCase can be converted to TestNG", (LocalQuickFix)new JUnitConverterQuickFix(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
            return new ProblemDescriptor[]{descriptor};
        }
        return null;
    }

    public static class JUnitConverterQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            if (JUnitConvertTool.QUICKFIX_NAME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/JUnitConvertTool$JUnitConverterQuickFix", "getName"));
            }
            return JUnitConvertTool.QUICKFIX_NAME;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/JUnitConvertTool$JUnitConverterQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/theoryinpractice/testng/inspection/JUnitConvertTool$JUnitConverterQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/theoryinpractice/testng/inspection/JUnitConvertTool$JUnitConverterQuickFix", "applyFix"));
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor.getPsiElement())) {
                return;
            }
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiClass.class);
            if (!TestNGUtil.checkTestNGInClasspath((PsiElement)psiClass)) {
                return;
            }
            try {
                PsiManager manager = PsiManager.getInstance((Project)project);
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
                PsiJavaFile javaFile = (PsiJavaFile)psiClass.getContainingFile();
                for (PsiMethod method : psiClass.getMethods()) {
                    PsiMethodCallExpression[] methodCalls;
                    if (method.isConstructor()) {
                        JUnitConverterQuickFix.convertJUnitConstructor(method);
                    } else if (!javaFile.getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_5)) {
                        JUnitConverterQuickFix.addMethodJavadoc(factory, method);
                    } else if (TestNGUtil.containsJunitAnnotions(method)) {
                        JUnitConverterQuickFix.convertJunitAnnotions(factory, method);
                    } else {
                        JUnitConverterQuickFix.addMethodAnnotations(factory, method);
                    }
                    for (PsiMethodCallExpression methodCall : methodCalls = JUnitConverterQuickFix.getTestCaseCalls(method)) {
                        PsiMethod assertMethod = methodCall.resolveMethod();
                        if (assertMethod == null) continue;
                        PsiAssertStatement assertStatement = null;
                        String methodName = assertMethod.getName();
                        PsiExpression[] expressions = methodCall.getArgumentList().getExpressions();
                        PsiStatement methodCallStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiStatement.class);
                        LOG.assertTrue(methodCallStatement != null);
                        if ("assertTrue".equals(methodName) || "assertFalse".equals(methodName)) {
                            PsiExpression assertCondition;
                            if (expressions.length == 1) {
                                assertStatement = JUnitConverterQuickFix.createAssert(factory, null, (PsiElement)methodCall);
                                assertCondition = assertStatement.getAssertCondition();
                                LOG.assertTrue(assertCondition != null);
                                assertCondition.replace((PsiElement)expressions[0]);
                            } else if (expressions.length == 2) {
                                assertStatement = JUnitConverterQuickFix.createAssert(factory, expressions[0], (PsiElement)methodCall);
                                assertCondition = assertStatement.getAssertCondition();
                                LOG.assertTrue(assertCondition != null);
                                assertCondition.replace((PsiElement)expressions[1]);
                            }
                            if ("assertFalse".equals(methodName) && assertStatement != null) {
                                assertCondition = assertStatement.getAssertCondition();
                                LOG.assertTrue(assertCondition != null);
                                assertCondition.replace((PsiElement)factory.createExpressionFromText("!(" + assertCondition.getText() + ')', PsiTreeUtil.getParentOfType((PsiElement)assertCondition, PsiMethodCallExpression.class)));
                            }
                        } else if ("assertNull".equals(methodName) || "assertNotNull".equals(methodName)) {
                            PsiExpression assertCondition;
                            PsiExpression expression;
                            String operator;
                            String string = operator = "assertNull".equals(methodName) ? "==" : "!=";
                            if (expressions.length == 1) {
                                assertStatement = JUnitConverterQuickFix.createAssert(factory, null, (PsiElement)methodCall);
                                expression = factory.createExpressionFromText(expressions[0].getText() + ' ' + operator + " null", (PsiElement)assertStatement);
                                assertCondition = assertStatement.getAssertCondition();
                                LOG.assertTrue(assertCondition != null);
                                assertCondition.replace((PsiElement)expression);
                            } else if (expressions.length == 2) {
                                assertStatement = JUnitConverterQuickFix.createAssert(factory, expressions[0], methodCall.getParent());
                                expression = factory.createExpressionFromText(expressions[1].getText() + ' ' + operator + " null", (PsiElement)assertStatement);
                                assertCondition = assertStatement.getAssertCondition();
                                LOG.assertTrue(assertCondition != null);
                                assertCondition.replace((PsiElement)expression);
                            }
                        } else if ("fail".equals(methodName)) {
                            if (expressions.length == 0) {
                                assertStatement = JUnitConverterQuickFix.createAssert(factory, null, (PsiElement)methodCall);
                            } else if (expressions.length == 1) {
                                assertStatement = JUnitConverterQuickFix.createAssert(factory, expressions[0], (PsiElement)methodCall);
                            }
                        } else {
                            PsiElement inserted = null;
                            if (expressions.length == 2) {
                                PsiExpression qualifierExpression = methodCall.getMethodExpression().getQualifierExpression();
                                String text = "org.testng." + (qualifierExpression == null ? "Assert." : "") + methodCall.getText() + ";";
                                inserted = methodCallStatement.replace((PsiElement)factory.createStatementFromText(text, methodCall.getParent()));
                            } else if (expressions.length == 3) {
                                String call = "org.testng.Assert." + methodName + '(' + expressions[2].getText() + ", " + expressions[1].getText() + ", " + expressions[0].getText() + ");";
                                inserted = methodCallStatement.replace((PsiElement)factory.createStatementFromText(call, methodCall.getParent()));
                            }
                            if (inserted != null) {
                                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(inserted);
                            }
                        }
                        if (assertStatement == null) continue;
                        methodCallStatement.replace((PsiElement)assertStatement);
                    }
                }
                PsiClass superClass = psiClass.getSuperClass();
                if (superClass != null && "junit.framework.TestCase".equals(superClass.getQualifiedName())) {
                    PsiReferenceList extendsList = psiClass.getExtendsList();
                    LOG.assertTrue(extendsList != null);
                    for (PsiJavaCodeReferenceElement element : extendsList.getReferenceElements()) {
                        element.delete();
                    }
                }
                JavaCodeStyleManager.getInstance((Project)project).optimizeImports((PsiFile)javaFile);
            }
            catch (IncorrectOperationException e) {
                LOG.error("Error converting testcase", (Throwable)e);
            }
        }

        private static void convertJunitAnnotions(PsiElementFactory factory, PsiMethod method) throws IncorrectOperationException {
            PsiAnnotation[] annotations;
            for (PsiAnnotation annotation : annotations = method.getModifierList().getAnnotations()) {
                PsiAnnotation newAnnotation = null;
                if ("org.junit.Test".equals(annotation.getQualifiedName())) {
                    newAnnotation = factory.createAnnotationFromText("@org.testng.annotations.Test", (PsiElement)method);
                } else if ("org.junit.BeforeClass".equals(annotation.getQualifiedName())) {
                    newAnnotation = factory.createAnnotationFromText("@org.testng.annotations.BeforeClass", (PsiElement)method);
                } else if ("org.junit.Before".equals(annotation.getQualifiedName())) {
                    newAnnotation = factory.createAnnotationFromText("@org.testng.annotations.BeforeMethod", (PsiElement)method);
                } else if ("org.junit.AfterClass".equals(annotation.getQualifiedName())) {
                    newAnnotation = factory.createAnnotationFromText("@org.testng.annotations.AfterClass", (PsiElement)method);
                } else if ("org.junit.After".equals(annotation.getQualifiedName())) {
                    newAnnotation = factory.createAnnotationFromText("@org.testng.annotations.AfterMethod", (PsiElement)method);
                }
                if (newAnnotation == null) continue;
                JavaCodeStyleManager.getInstance((Project)annotation.getProject()).shortenClassReferences(annotation.replace((PsiElement)newAnnotation));
            }
        }

        private static void convertJUnitConstructor(PsiMethod method) {
            method.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitExpressionStatement(PsiExpressionStatement statement) {
                    PsiMethod resolved;
                    PsiMethodCallExpression methodCall;
                    PsiExpression expression = statement.getExpression();
                    if (expression instanceof PsiMethodCallExpression && (methodCall = (PsiMethodCallExpression)expression).getArgumentList().getExpressions().length == 1 && (resolved = methodCall.resolveMethod()) != null && "junit.framework.TestCase".equals(resolved.getContainingClass().getQualifiedName()) && "TestCase".equals(resolved.getName())) {
                        try {
                            statement.delete();
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
            });
        }

        private static PsiMethodCallExpression[] getTestCaseCalls(PsiMethod method) {
            PsiElement[] methodCalls = PsiTreeUtil.collectElements((PsiElement)method, (PsiElementFilter)new PsiElementFilter(){

                public boolean isAccepted(PsiElement element) {
                    String qualifiedName;
                    PsiClass containingClass;
                    if (!(element instanceof PsiMethodCallExpression)) {
                        return false;
                    }
                    PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element;
                    PsiMethod method = methodCall.resolveMethod();
                    return method != null && (containingClass = method.getContainingClass()) != null && ("junit.framework.Assert".equals(qualifiedName = containingClass.getQualifiedName()) || "org.junit.Assert".equals(qualifiedName) || "junit.framework.TestCase".equals(qualifiedName));
                }
            });
            PsiMethodCallExpression[] expressions = new PsiMethodCallExpression[methodCalls.length];
            System.arraycopy(methodCalls, 0, expressions, 0, methodCalls.length);
            return expressions;
        }

        private static void addMethodJavadoc(PsiElementFactory factory, PsiMethod method) throws IncorrectOperationException {
            if (method.getName().startsWith("test")) {
                JUnitConverterQuickFix.addMethodJavadocLine(factory, method, " * @testng.test");
            } else if ("setUp".equals(method.getName()) && method.getParameterList().getParameters().length == 0) {
                JUnitConverterQuickFix.addMethodJavadocLine(factory, method, " * @testng.before-test");
            } else if ("tearDown".equals(method.getName()) && method.getParameterList().getParameters().length == 0) {
                JUnitConverterQuickFix.addMethodJavadocLine(factory, method, " * @testng.after-test");
            }
        }

        private static void addMethodJavadocLine(PsiElementFactory factory, PsiMethod method, @NonNls String javaDocLine) throws IncorrectOperationException {
            PsiElement comment = method.getFirstChild();
            if (comment != null && comment instanceof PsiComment) {
                String[] commentLines = comment.getText().split("\n");
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < commentLines.length; ++i) {
                    String commentLine = commentLines[i];
                    if (i == commentLines.length - 1) {
                        buf.append(javaDocLine);
                        buf.append(commentLine);
                        continue;
                    }
                    buf.append(commentLine);
                    buf.append('\n');
                }
                String commentString = buf.toString();
                PsiComment newComment = factory.createCommentFromText(commentString, null);
                comment.replace((PsiElement)newComment);
            } else {
                StringBuffer commentBuffer = new StringBuffer();
                commentBuffer.append("/**\n");
                commentBuffer.append(javaDocLine);
                commentBuffer.append('\n');
                commentBuffer.append(" */");
                String commentString = commentBuffer.toString();
                PsiComment newComment = factory.createCommentFromText(commentString, null);
                method.addBefore((PsiElement)newComment, comment);
            }
        }

        private static void addMethodAnnotations(PsiElementFactory factory, PsiMethod method) throws IncorrectOperationException {
            PsiAnnotation annotation = null;
            if (method.getName().startsWith("test")) {
                annotation = factory.createAnnotationFromText("@org.testng.annotations.Test", (PsiElement)method);
            } else if ("setUp".equals(method.getName()) && method.getParameterList().getParameters().length == 0) {
                annotation = factory.createAnnotationFromText("@org.testng.annotations.BeforeMethod", (PsiElement)method);
            } else if ("tearDown".equals(method.getName()) && method.getParameterList().getParameters().length == 0) {
                annotation = factory.createAnnotationFromText("@org.testng.annotations.AfterMethod", (PsiElement)method);
            }
            if (annotation != null) {
                JavaCodeStyleManager.getInstance((Project)annotation.getProject()).shortenClassReferences(method.getModifierList().addAfter((PsiElement)annotation, null));
            }
        }

        private static PsiAssertStatement createAssert(PsiElementFactory factory, PsiExpression description, PsiElement context) throws IncorrectOperationException {
            if (description == null) {
                PsiAssertStatement assertStatement = (PsiAssertStatement)factory.createStatementFromText("assert false;", context.getParent());
                return assertStatement;
            }
            PsiAssertStatement assertStatement = (PsiAssertStatement)factory.createStatementFromText("assert false : \"x\";", context.getParent());
            PsiExpression assertDescription = assertStatement.getAssertDescription();
            assert (assertDescription != null);
            assertDescription.replace((PsiElement)description);
            return assertStatement;
        }
    }
}

