/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuiltinMethodsWithDifferentJvmName {
    @NotNull
    public static final FqName REMOVE_AT_FQ_NAME;
    @NotNull
    public static final Map<FqName, ? extends Name> FQ_NAMES_TO_JVM_MAP;
    @NotNull
    public static final List<? extends Name> ORIGINAL_SHORT_NAMES;
    @NotNull
    public static final Map<Name, ? extends List<? extends Name>> JVM_SHORT_NAME_TO_BUILTIN_SHORT_NAMES_MAP;
    public static final BuiltinMethodsWithDifferentJvmName INSTANCE;
    public static final BuiltinMethodsWithDifferentJvmName INSTANCE$;

    @NotNull
    public final FqName getREMOVE_AT_FQ_NAME() {
        return REMOVE_AT_FQ_NAME;
    }

    @NotNull
    public final Map<FqName, Name> getFQ_NAMES_TO_JVM_MAP() {
        return FQ_NAMES_TO_JVM_MAP;
    }

    @NotNull
    public final List<Name> getORIGINAL_SHORT_NAMES() {
        return ORIGINAL_SHORT_NAMES;
    }

    @NotNull
    public final Map<Name, List<? extends Name>> getJVM_SHORT_NAME_TO_BUILTIN_SHORT_NAMES_MAP() {
        return JVM_SHORT_NAME_TO_BUILTIN_SHORT_NAMES_MAP;
    }

    public final boolean getSameAsRenamedInJvmBuiltin(Name $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return ORIGINAL_SHORT_NAMES.contains($receiver);
    }

    @Nullable
    public final Name getJvmName(@NotNull CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkParameterIsNotNull(callableMemberDescriptor, "callableMemberDescriptor");
        FqName fqName2 = SpecialBuiltinMembers.access$fqNameOrNull(callableMemberDescriptor);
        if (fqName2 == null) {
            return null;
        }
        return FQ_NAMES_TO_JVM_MAP.get(fqName2);
    }

    public final boolean isBuiltinFunctionWithDifferentNameInJvm(@NotNull CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkParameterIsNotNull(callableMemberDescriptor, "callableMemberDescriptor");
        if (!SpecialBuiltinMembers.access$isFromBuiltins(callableMemberDescriptor)) {
            return false;
        }
        FqName fqName2 = SpecialBuiltinMembers.access$fqNameOrNull(callableMemberDescriptor);
        if (fqName2 == null) {
            return false;
        }
        FqName fqName3 = fqName2;
        return SpecialBuiltinMembers.access$firstOverridden(callableMemberDescriptor, (Function1<? super CallableMemberDescriptor, ? extends Boolean>)new Function1<CallableMemberDescriptor, Boolean>(fqName3){
            final /* synthetic */ FqName $fqName;

            public final boolean invoke(@NotNull CallableMemberDescriptor it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return BuiltinMethodsWithDifferentJvmName.INSTANCE.getFQ_NAMES_TO_JVM_MAP().containsKey(this.$fqName);
            }
            {
                this.$fqName = fqName2;
                super(1);
            }
        }) != null;
    }

    @NotNull
    public final List<Name> getBuiltinFunctionNamesByJvmName(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        List<Name> list = JVM_SHORT_NAME_TO_BUILTIN_SHORT_NAMES_MAP.get(name);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final boolean isRemoveAtByIndex(CallableMemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return Intrinsics.areEqual($receiver.getName().asString(), "removeAt") && Intrinsics.areEqual(SpecialBuiltinMembers.access$fqNameOrNull($receiver), REMOVE_AT_FQ_NAME);
    }

    static {
        new BuiltinMethodsWithDifferentJvmName();
    }

    /*
     * WARNING - void declaration
     */
    private BuiltinMethodsWithDifferentJvmName() {
        void var3_3;
        void $receiver;
        INSTANCE = this;
        INSTANCE$ = this;
        REMOVE_AT_FQ_NAME = new FqName("kotlin.MutableList.removeAt");
        FQ_NAMES_TO_JVM_MAP = MapsKt.mapOf(TuplesKt.to(new FqName("kotlin.Number.toByte"), Name.identifier("byteValue")), TuplesKt.to(new FqName("kotlin.Number.toShort"), Name.identifier("shortValue")), TuplesKt.to(new FqName("kotlin.Number.toInt"), Name.identifier("intValue")), TuplesKt.to(new FqName("kotlin.Number.toLong"), Name.identifier("longValue")), TuplesKt.to(new FqName("kotlin.Number.toFloat"), Name.identifier("floatValue")), TuplesKt.to(new FqName("kotlin.Number.toDouble"), Name.identifier("doubleValue")), TuplesKt.to(REMOVE_AT_FQ_NAME, Name.identifier("remove")), TuplesKt.to(new FqName("kotlin.CharSequence.get"), Name.identifier("charAt")));
        Object $receiver2 = FQ_NAMES_TO_JVM_MAP;
        $receiver2 = $receiver2.keySet();
        Object $i$f$keySet = $receiver2;
        Collection destination = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it;
            FqName fqName2 = (FqName)item;
            Collection collection = destination;
            Name name = it.shortName();
            collection.add(name);
        }
        ORIGINAL_SHORT_NAMES = (List)var3_3;
        JVM_SHORT_NAME_TO_BUILTIN_SHORT_NAMES_MAP = SpecialBuiltinMembers.access$getInversedShortNamesMap(FQ_NAMES_TO_JVM_MAP);
    }
}

