/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.output;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.blame.output.GradleMessageRewriter;
import com.android.ide.common.blame.parser.LegacyNdkOutputParser;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.blame.parser.aapt.AaptOutputParser;
import com.android.utils.ILogger;
import com.google.common.base.Strings;

public class BlameRewritingLogger
implements ILogger {
    private final ILogger mLogger;
    private final GradleMessageRewriter mGradleMessageRewriter;

    public BlameRewritingLogger(@NonNull ILogger logger, @NonNull GradleMessageRewriter.ErrorFormatMode errorFormatMode) {
        this.mLogger = logger;
        PatternAwareOutputParser[] parsers = new PatternAwareOutputParser[]{new AaptOutputParser(), new LegacyNdkOutputParser()};
        ToolOutputParser parser = new ToolOutputParser(parsers, logger);
        this.mGradleMessageRewriter = new GradleMessageRewriter(parser, errorFormatMode);
    }

    public void error(@Nullable Throwable t, @Nullable String msgFormat, Object ... args) {
        this.mLogger.error(t, this.mGradleMessageRewriter.rewriteMessages(Strings.nullToEmpty((String)msgFormat)), args);
    }

    public void warning(@NonNull String msgFormat, Object ... args) {
        this.mLogger.warning(this.mGradleMessageRewriter.rewriteMessages(msgFormat), args);
    }

    public void info(@NonNull String msgFormat, Object ... args) {
        this.mLogger.info(msgFormat, args);
    }

    public void verbose(@NonNull String msgFormat, Object ... args) {
        this.mLogger.verbose(msgFormat, args);
    }
}

