/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.internal;

import com.android.annotations.NonNull;
import com.android.ide.common.internal.PngCruncher;
import com.android.ide.common.internal.PngException;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfo;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import java.io.File;

public class AaptCruncher
implements PngCruncher {
    @NonNull
    private final String mAaptLocation;
    @NonNull
    private final ProcessExecutor mProcessExecutor;
    @NonNull
    private final ProcessOutputHandler mProcessOutputHandler;

    public AaptCruncher(@NonNull String aaptLocation, @NonNull ProcessExecutor processExecutor, @NonNull ProcessOutputHandler processOutputHandler) {
        this.mAaptLocation = aaptLocation;
        this.mProcessExecutor = processExecutor;
        this.mProcessOutputHandler = processOutputHandler;
    }

    @Override
    public int start() {
        return 0;
    }

    @Override
    public void crunchPng(int key, @NonNull File from, @NonNull File to) throws PngException {
        try {
            ProcessInfo processInfo = new ProcessInfoBuilder().setExecutable(this.mAaptLocation).addArgs("s", "-i", from.getAbsolutePath(), "-o", to.getAbsolutePath()).createProcess();
            ProcessResult result = this.mProcessExecutor.execute(processInfo, this.mProcessOutputHandler);
            result.rethrowFailure().assertNormalExitValue();
        }
        catch (ProcessException e) {
            throw new PngException(e);
        }
    }

    @Override
    public void end(int key) throws InterruptedException {
    }
}

