/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.settings.ClassHolder;
import org.jetbrains.plugins.gradle.settings.DistributionType;

public class GradleExecutionSettings
extends ExternalSystemExecutionSettings {
    private static final boolean USE_VERBOSE_GRADLE_API_BY_DEFAULT = Boolean.parseBoolean(System.getProperty("gradle.api.verbose"));
    private static final long serialVersionUID = 1L;
    @NotNull
    private final List<ClassHolder<? extends GradleProjectResolverExtension>> myResolverExtensions;
    @Nullable
    private final String myGradleHome;
    @Nullable
    private final String myServiceDirectory;
    @Nullable
    private final String myDaemonVmOptions;
    private final boolean myIsOfflineWork;
    @NotNull
    private final DistributionType myDistributionType;
    @Nullable
    private String wrapperPropertyFile;
    @Nullable
    private String myJavaHome;

    public GradleExecutionSettings(@Nullable String gradleHome, @Nullable String serviceDirectory, @NotNull DistributionType distributionType, @Nullable String daemonVmOptions, boolean isOfflineWork) {
        if (distributionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "distributionType", "org/jetbrains/plugins/gradle/settings/GradleExecutionSettings", "<init>"));
        }
        this.myResolverExtensions = ContainerUtilRt.newArrayList();
        this.myGradleHome = gradleHome;
        this.myServiceDirectory = serviceDirectory;
        this.myDistributionType = distributionType;
        this.myDaemonVmOptions = daemonVmOptions;
        this.myIsOfflineWork = isOfflineWork;
        this.setVerboseProcessing(USE_VERBOSE_GRADLE_API_BY_DEFAULT);
    }

    @Nullable
    public String getGradleHome() {
        return this.myGradleHome;
    }

    @Nullable
    public String getServiceDirectory() {
        return this.myServiceDirectory;
    }

    @Nullable
    public String getJavaHome() {
        return this.myJavaHome;
    }

    public void setJavaHome(@Nullable String javaHome) {
        this.myJavaHome = javaHome;
    }

    public boolean isOfflineWork() {
        return this.myIsOfflineWork;
    }

    @NotNull
    public List<ClassHolder<? extends GradleProjectResolverExtension>> getResolverExtensions() {
        List<ClassHolder<? extends GradleProjectResolverExtension>> list = this.myResolverExtensions;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/settings/GradleExecutionSettings", "getResolverExtensions"));
        }
        return list;
    }

    public void addResolverExtensionClass(@NotNull ClassHolder<? extends GradleProjectResolverExtension> holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/gradle/settings/GradleExecutionSettings", "addResolverExtensionClass"));
        }
        this.myResolverExtensions.add(holder);
    }

    @Nullable
    public String getDaemonVmOptions() {
        return this.myDaemonVmOptions;
    }

    @Nullable
    public String getWrapperPropertyFile() {
        return this.wrapperPropertyFile;
    }

    public void setWrapperPropertyFile(@Nullable String wrapperPropertyFile) {
        this.wrapperPropertyFile = wrapperPropertyFile;
    }

    @NotNull
    public DistributionType getDistributionType() {
        DistributionType distributionType = this.myDistributionType;
        if (distributionType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/settings/GradleExecutionSettings", "getDistributionType"));
        }
        return distributionType;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myGradleHome != null ? this.myGradleHome.hashCode() : 0);
        result = 31 * result + (this.myServiceDirectory != null ? this.myServiceDirectory.hashCode() : 0);
        result = 31 * result + this.myDistributionType.hashCode();
        result = 31 * result + (this.myJavaHome != null ? this.myJavaHome.hashCode() : 0);
        result = 31 * result + (this.myDaemonVmOptions == null ? 0 : this.myDaemonVmOptions.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        GradleExecutionSettings that = (GradleExecutionSettings)((Object)o);
        if (this.myDistributionType != that.myDistributionType) {
            return false;
        }
        if (!Comparing.equal((String)this.myDaemonVmOptions, (String)that.myDaemonVmOptions)) {
            return false;
        }
        if (this.myGradleHome != null ? !this.myGradleHome.equals(that.myGradleHome) : that.myGradleHome != null) {
            return false;
        }
        if (this.myJavaHome != null ? !this.myJavaHome.equals(that.myJavaHome) : that.myJavaHome != null) {
            return false;
        }
        return !(this.myServiceDirectory != null ? !this.myServiceDirectory.equals(that.myServiceDirectory) : that.myServiceDirectory != null);
    }

    public String toString() {
        return "home: " + this.myGradleHome + ", distributionType: " + (Object)((Object)this.myDistributionType);
    }
}

