/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import kotlin.ByteIterator;
import kotlin.Charsets;
import kotlin.Deprecated;
import kotlin.StringsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"W\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\u0003\u0006\u0001\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005Aq!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005AI!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\u0011%)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\"\u0004\u0005\u0001\u001b\u0005A\n!F\u0001\u0019\u0002e-A!\u0001\u0005\u0002\u001b\u0005A\u001a\u0001UB\u0001)\u000e\u0011Q\"\u0004\u0005\u0001\u001b\u0005A*!F\u0001\u0019\u0007e-A!\u0001\u0005\u0002\u001b\u0005A\u001a\u0001UB\u0001)\u000e\u0011Q\"\u0004E\u0004\u001b\u0005AB!F\u0001\u0019\u0002e-A!\u0001E\u0005\u001b\u0005AR\u0001UB\u0001)\u000e\u0011Q\u0002\u0004E\u0004\u001b\u0005AB!F\u0001\u0019\u0002e%\u0001\u0012B\u0007\u00021\u0017\u00016\u0011\u0001+\u0004\u00055i\u0001BB\u0007\u00021\u001b)\u0012\u0001G\u0002\u001a\f\u0011\t\u0001\u0012B\u0007\u00021\u0015\u00016\u0011\u0001+\u0004\u00055a\u0001BB\u0007\u00021\u001b)\u0012\u0001G\u0002\u001a\n!%Q\"\u0001M\u0006!\u000e\u0005Ak\u0001\u0002\u000e\u001b!9Q\"\u0001M\u0001+\u0005AZ!g\u0003\u0005\u0003!%Q\"\u0001\r\u0006!\u000e\u0005Ak\u0001\u0002\u000e&!=Q\"\u0001\r\t+\u0005A\n!'\u0003\t\u00125\t\u0001d\u0001)\u0004\u0002e-A!\u0001\u0005\u0002\u001b\u0005A\u001a\u0001U\u0002\u0002)\u000e\u0011QR\u0002\u0005\n\u001b\u0005A\u001a\"F\u0001\u0019\u0015Q\u001b!!d\t\t\u00135\t\u00014C\u000b\u00021)IJ\u0001#\u0006\u000e\u0003a\r\u0001k!\u0001\u001a\n!YQ\"\u0001M\u0002!\u000e\tAk\u0001\u0002\u000e\u0010\u0011\u001d\u0001rC\u0007\u000211)\u0012\u0001'\u0001U\u0007\tiQ\u0002#\u0007\u000e\u0003aQQ#\u0001M\u00013\u0017!\u0011\u0001C\u0007\u000e\u0003a\r\u0001k!\u0001U\u0007\tiQ\u0002c\u0007\u000e\u0003aqQ#\u0001M\u00013\u0017!\u0011\u0001#\u0003\u000e\u0003a)\u0001k!\u0001U\u0007\tiA\u0002c\u0007\u000e\u0003aqQ#\u0001M\u00013\u0013AI!D\u0001\u0019\fA\u001b\t\u0001V\u0002\u0003\u001b5Ai\"D\u0001\u0019\u001fU\t\u0001dAM\u0006\t\u0005AI!D\u0001\u0019\u000bA\u001b\t\u0001V\u0002\u0003\u001b1Ai\"D\u0001\u0019\u001fU\t\u0001dAM\u0005\u0011\u0013i\u0011\u0001g\u0003Q\u0007\u0003!6A\u0001"}, strings={"buffered", "Ljava/io/InputStream;", "bufferSize", "", "ByteStreamsKt", "Ljava/io/BufferedOutputStream;", "Ljava/io/OutputStream;", "bufferedReader", "Ljava/io/BufferedReader;", "charset", "Ljava/nio/charset/Charset;", "", "bufferedWriter", "Ljava/io/BufferedWriter;", "byteInputStream", "copyTo", "", "out", "inputStream", "Ljava/io/ByteArrayInputStream;", "", "offset", "length", "iterator", "Lkotlin/ByteIterator;", "readBytes", "estimatedSize", "reader", "Ljava/io/InputStreamReader;", "writer", "Ljava/io/OutputStreamWriter;"}, moduleName="kotlin-stdlib")
@JvmName(name="ByteStreamsKt")
public final class ByteStreamsKt {
    @Deprecated(message="It's not recommended to iterate through input stream bytes")
    @NotNull
    public static final ByteIterator iterator(InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new ByteIterator($receiver){
            private int nextByte;
            private boolean nextPrepared;
            private boolean finished;
            final /* synthetic */ InputStream receiver$0;

            public final int getNextByte() {
                return this.nextByte;
            }

            public final void setNextByte(int n) {
                this.nextByte = n;
            }

            public final boolean getNextPrepared() {
                return this.nextPrepared;
            }

            public final void setNextPrepared(boolean bl) {
                this.nextPrepared = bl;
            }

            public final boolean getFinished() {
                return this.finished;
            }

            public final void setFinished(boolean bl) {
                this.finished = bl;
            }

            private final void prepareNext() {
                if (!this.nextPrepared && !this.finished) {
                    this.nextByte = this.receiver$0.read();
                    this.nextPrepared = true;
                    this.finished = this.nextByte == -1;
                }
            }

            public boolean hasNext() {
                this.prepareNext();
                return !this.finished;
            }

            public byte nextByte() {
                this.prepareNext();
                if (this.finished) {
                    throw (Throwable)new NoSuchElementException("Input stream is over");
                }
                byte res = (byte)this.nextByte;
                this.nextPrepared = false;
                return res;
            }
            {
                this.receiver$0 = $receiver;
                this.nextByte = -1;
            }

            public void remove() {
                throw new UnsupportedOperationException("Mutating immutable collection");
            }
        };
    }

    @NotNull
    public static final InputStream byteInputStream(String $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new ByteArrayInputStream(StringsKt.toByteArray($receiver, charset));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ InputStream byteInputStream$default(String string, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return ByteStreamsKt.byteInputStream(string, charset);
    }

    @NotNull
    public static final ByteArrayInputStream inputStream(byte[] $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new ByteArrayInputStream($receiver);
    }

    @NotNull
    public static final ByteArrayInputStream inputStream(byte[] $receiver, int offset, int length) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new ByteArrayInputStream($receiver, offset, length);
    }

    @NotNull
    public static final InputStream buffered(InputStream $receiver, int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof BufferedInputStream ? (BufferedInputStream)$receiver : new BufferedInputStream($receiver, bufferSize);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ InputStream buffered$default(InputStream inputStream, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = FilesKt.getDefaultBufferSize();
        }
        return ByteStreamsKt.buffered(inputStream, n);
    }

    @NotNull
    public static final InputStreamReader reader(InputStream $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new InputStreamReader($receiver, charset);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ InputStreamReader reader$default(InputStream inputStream, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return ByteStreamsKt.reader(inputStream, charset);
    }

    @NotNull
    public static final BufferedReader bufferedReader(InputStream $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return TextStreamsKt.buffered$default(ByteStreamsKt.reader($receiver, charset), 0, 1);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ BufferedReader bufferedReader$default(InputStream inputStream, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return ByteStreamsKt.bufferedReader(inputStream, charset);
    }

    @NotNull
    public static final InputStreamReader reader(InputStream $receiver, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new InputStreamReader($receiver, charset);
    }

    @NotNull
    public static final BufferedReader bufferedReader(InputStream $receiver, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return TextStreamsKt.buffered$default(ByteStreamsKt.reader($receiver, charset), 0, 1);
    }

    @NotNull
    public static final BufferedOutputStream buffered(OutputStream $receiver, int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof BufferedOutputStream ? (BufferedOutputStream)$receiver : new BufferedOutputStream($receiver, bufferSize);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ BufferedOutputStream buffered$default(OutputStream outputStream, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = FilesKt.getDefaultBufferSize();
        }
        return ByteStreamsKt.buffered(outputStream, n);
    }

    @NotNull
    public static final OutputStreamWriter writer(OutputStream $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new OutputStreamWriter($receiver, charset);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ OutputStreamWriter writer$default(OutputStream outputStream, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return ByteStreamsKt.writer(outputStream, charset);
    }

    @NotNull
    public static final BufferedWriter bufferedWriter(OutputStream $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return TextStreamsKt.buffered$default(ByteStreamsKt.writer($receiver, charset), 0, 1);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ BufferedWriter bufferedWriter$default(OutputStream outputStream, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return ByteStreamsKt.bufferedWriter(outputStream, charset);
    }

    @NotNull
    public static final OutputStreamWriter writer(OutputStream $receiver, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new OutputStreamWriter($receiver, charset);
    }

    @NotNull
    public static final BufferedWriter bufferedWriter(OutputStream $receiver, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return TextStreamsKt.buffered$default(ByteStreamsKt.writer($receiver, charset), 0, 1);
    }

    public static final long copyTo(InputStream $receiver, @NotNull OutputStream out, int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(out, "out");
        long bytesCopied = 0L;
        byte[] buffer = new byte[bufferSize];
        int bytes = $receiver.read(buffer);
        while (bytes >= 0) {
            out.write(buffer, 0, bytes);
            bytesCopied += (long)bytes;
            bytes = $receiver.read(buffer);
        }
        return bytesCopied;
    }

    public static /* bridge */ /* synthetic */ long copyTo$default(InputStream inputStream, OutputStream outputStream, int n, int n2) {
        if ((n2 & 2) != 0) {
            n = FilesKt.getDefaultBufferSize();
        }
        return ByteStreamsKt.copyTo(inputStream, outputStream, n);
    }

    @NotNull
    public static final byte[] readBytes(InputStream $receiver, int estimatedSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(estimatedSize);
        ByteStreamsKt.copyTo$default($receiver, buffer, 0, 2);
        byte[] byArray = buffer.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "buffer.toByteArray()");
        return byArray;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ byte[] readBytes$default(InputStream inputStream, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = FilesKt.getDefaultBufferSize();
        }
        return ByteStreamsKt.readBytes(inputStream, n);
    }
}

