/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.ReplaceWith;
import kotlin.Sequence;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.io.FilePathComponents;
import kotlin.io.FilesKt;
import kotlin.io.FilesKt__UtilsKt;
import kotlin.io.FilesKt__UtilsKt$sam$FileFilter$ace751fe;
import kotlin.io.NoSuchFileException;
import kotlin.io.OnErrorAction;
import kotlin.io.TerminateException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinMultifileClassPart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinMultifileClassPart(version={1, 0, 0}, abiVersion=32, data={"G\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\t\u000f\u0015\tAaB\u0003\u0002\u0011\u0017)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!%Q!\u0001\u0003\u0002\u000b\u0005AA!B\u0001\u0005\u0005\u0015\t\u0001\u0012C\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\r5-\u0002rB\u0007\u00021\u0003IB\u0001B\u0001\t\u00115\t\u0001dA\r\u0006\t\u0005A\t\"\u0004\u0002\r\u0002a\u0019\u0011$\u0002\u0003\u0002\u0011\u0001i!\u0001$\u0001\u0019\u0002Q\u001b!!d\u000b\t\u00135\t\u0001\u0014A\r\u0005\t\u0005A\u0001\"D\u0001\u0019\u0007e)A!\u0001E\t\u001b\ta\t\u0001G\u0002\u001a\u000b\u0011\t\u0001\u0002A\u0007\u0003\u0019\u0003A\n\u0001V\u0002\u0003\u001b\u001f!9\u0001c\u0005\u000e\u0003a\u0019Q#\u0001\r\u0004)\u000e\u0011Qr\u0007\u0005\u000b\u001b\u0005A*\"F\u0001\u0019\u0002e%\u0001bC\u0007\u00021\u0003\u00016\u0011AM\u000f\t\u0005A9\"\u0004\u0006\n\u0005%\t\u0001\u0014A\u0005\u0003\u0013\u0005AJ\"\u0003\u0002\n\u0003ai\u0001\u0004\u0004)\u0004\u0003Q\u001b!!D\r\t\u001c5\t\u0001DD\u000b\u00021\u0003IJ\u0001C\u0006\u000e\u0003a\u0005\u0001k!\u0001\u001a\f\u0011\t\u0001RD\u0007\u00021+\u00016!AM\u0006\t\u0005Aq\"D\u0001\u0019 A\u001b\u0019\u0001V\u0002\u0003\u001b\u001bA\u0001#D\u0001\u0019\u0016U\t\u0001\u0014\u0001+\u0004\u00055a\u0001\u0012E\u0007\u00021+)\u0012\u0001'\u0001\u001a\n!\tR\"\u0001M\u0001!\u000e\u0005Ak\u0001\u0002\u000e\u0019!\u0005R\"\u0001M\u000b+\u0005A\n!'\u0003\t#5\t\u0001d\u0001)\u0004\u0002Q\u001b!!$\r\t$5)\u0011BA\u0005\u00021\u0003a\t\u0001\u0007\n\u0016\u0003a\u0005\u0011T\u0003E\u0013\u001b\u001dI!!C\u0001\u0019\u0002%\u0011\u0011\"\u0001M\u000b1M\u00016\u0011A)\u0004\u0003!\u001dBk\u0001\u0002\u000e\u000e!!R\"\u0001M\u0001+\u0005A\n\u0001V\u0002\u0003\u001b\u001f!9\u0001#\u000b\u000e\u0003a\u0019Q#\u0001\r\u0004)\u000e\u0011Q\"\u0004C\u0004\u0011Ui\u0011\u0001G\u0002\u0016\u0003a\u0005\u0011\u0014\u0002E\u0016\u001b\u0005A\n\u0001UB\u0001)\u000e\u0011Q\u0002\u0004\u0005\u0017\u001b\u0005A2!F\u0001\u0019\u0002e%\u0001RF\u0007\u00021\u0003\u00016\u0011\u0001+\u0004\u00055a\u0001bF\u0007\u00021\u0003)\u0012\u0001'\u0001\u001a\n!=R\"\u0001M\u0001!\u000e\u0005Ak\u0001\u0002\u000e\u0019!9R\"\u0001M\u0001+\u0005A\n!'\u0003\t05\t\u0001d\u0001)\u0004\u0002Q\u001b!!\u0004\u0007\t15\t\u0001\u0014A\u000b\u00021\u0003IJ\u0001c\f\u000e\u0003a\u0005\u0001k!\u0001U\u0007\tiA\u0002\u0003\r\u000e\u0003a\u0005Q#\u0001M\u00013\u0013Ay#D\u0001\u0019\u0007A\u001b\t\u0001V\u0002\u0003\u001b\u001bA\t$D\u0001\u0019\u0007U\t\u0001\u0014\u0001+\u0004\u00055=Aq\u0001E\u0019\u001b\u0005A2!F\u0001\u0019\u0007Q\u001b!!\u0004\u0007\t35\t\u0001TC\u000b\u00021\u0003IJ\u0001C\t\u000e\u0003a\u0005\u0001k!\u0001U\u0007\tiA\u0002C\r\u000e\u0003aUQ#\u0001M\u00013\u0013A\u0011#D\u0001\u0019\u0007A\u001b\t\u0001V\u0002\u0003#7!1\t\u0003\u0005\u0001\u001b\u0005A\n!F\u0001\u0019\u0002q\u0019\u0013kA\u0002\u000e\u0005\u0011\t\u00012\u0001+\u0004\u0005EmAa\u0011\u0005\t\u00065\t\u0001dA\u000b\u00021\u0003a2%U\u0002\u0004\u001b\t!9\u0001\u0003\u0003U\u0007\t\tZ\u0002B\"\t\u0011\u0013i\u0011\u0001G\u0002\u0016\u0003a\u0005AdI)\u0004\u00075\u0011A!\u0002\u0005\u0005)\u000e\u0011\u00113\u0005CD\u0011!-QB\u0001G\u00011\u0003)\u0012\u0001'\u0001\u001dGE\u001ba!\u0003\u0002\u0005\r!5QB\u0001\u0003\b\u0011\u0007!6A\u0001"}, strings={"directory", "Ljava/io/File;", "getDirectory", "(Ljava/io/File;)Ljava/io/File;", "FilesKt__UtilsKt", "extension", "", "getExtension", "(Ljava/io/File;)Ljava/lang/String;", "nameWithoutExtension", "getNameWithoutExtension", "parent", "parent$annotations", "(Ljava/io/File;)V", "getParent", "createTempDir", "prefix", "suffix", "createTempFile", "allSeparatorsToSystem", "copyRecursively", "", "dst", "onError", "Lkotlin/Function2;", "Ljava/io/IOException;", "Lkotlin/io/OnErrorAction;", "copyTo", "", "overwrite", "bufferSize", "", "deleteRecursively", "endsWith", "other", "listFiles", "", "filter", "Lkotlin/Function1;", "(Ljava/io/File;Lkotlin/jvm/functions/Function1;)[Ljava/io/File;", "normalize", "pathSeparatorsToSystem", "relativePath", "descendant", "relativeTo", "base", "resolve", "relative", "resolveSibling", "separatorsToSystem", "startsWith"}, multifileClassName="kotlin/io/FilesKt")
final class FilesKt__UtilsKt {
    @NotNull
    public static final File createTempDir(@NotNull String prefix, @Nullable String suffix, @Nullable File directory) {
        Intrinsics.checkParameterIsNotNull(prefix, "prefix");
        File dir = File.createTempFile(prefix, suffix, directory);
        dir.delete();
        if (dir.mkdir()) {
            File file = dir;
            Intrinsics.checkExpressionValueIsNotNull(file, "dir");
            return file;
        }
        throw (Throwable)new IOException("Unable to create temporary directory " + dir);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ File createTempDir$default(String string, String string2, File file, int n) {
        if ((n & 1) != 0) {
            string = "tmp";
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        return FilesKt.createTempDir(string, string2, file);
    }

    @NotNull
    public static final File createTempFile(@NotNull String prefix, @Nullable String suffix, @Nullable File directory) {
        Intrinsics.checkParameterIsNotNull(prefix, "prefix");
        File file = File.createTempFile(prefix, suffix, directory);
        Intrinsics.checkExpressionValueIsNotNull(file, "File.createTempFile(prefix, suffix, directory)");
        return file;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ File createTempFile$default(String string, String string2, File file, int n) {
        if ((n & 1) != 0) {
            string = "tmp";
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        return FilesKt.createTempFile(string, string2, file);
    }

    @NotNull
    public static final File getDirectory(File $receiver) {
        File file;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver.isDirectory()) {
            file = $receiver;
        } else {
            file = $receiver.getParentFile();
            if (file == null) {
                Intrinsics.throwNpe();
            }
        }
        return file;
    }

    @Deprecated(message="Use parentFile", replaceWith=@ReplaceWith(imports={}, expression="parentFile"), level=DeprecationLevel.ERROR)
    private static final /* synthetic */ void parent$annotations(File file) {
    }

    @Nullable
    public static final File getParent(File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getParentFile();
    }

    @NotNull
    public static final String getExtension(File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return StringsKt.substringAfterLast($receiver.getName(), '.', "");
    }

    @Deprecated(message="Use File.separatorsToSystem instead", replaceWith=@ReplaceWith(imports={"java.io.File"}, expression="File(this).separatorsToSystem()"))
    @NotNull
    public static final String separatorsToSystem(String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        String otherSep = Intrinsics.areEqual(File.separator, "/") ? "\\" : "/";
        String string = File.separator;
        Intrinsics.checkExpressionValueIsNotNull(string, "File.separator");
        return StringsKt.replace$default($receiver, otherSep, string, false, 4);
    }

    @Deprecated(message="This function is deprecated")
    @NotNull
    public static final String pathSeparatorsToSystem(String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        String otherSep = Intrinsics.areEqual(File.pathSeparator, ":") ? ";" : ":";
        String string = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull(string, "File.pathSeparator");
        return StringsKt.replace$default($receiver, otherSep, string, false, 4);
    }

    @Deprecated(message="This function is deprecated")
    @NotNull
    public static final String allSeparatorsToSystem(String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FilesKt.pathSeparatorsToSystem(FilesKt.separatorsToSystem($receiver));
    }

    @NotNull
    public static final String separatorsToSystem(File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FilesKt.separatorsToSystem($receiver.toString());
    }

    @NotNull
    public static final String getNameWithoutExtension(File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return StringsKt.substringBeforeLast$default($receiver.getName(), ".", null, 2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String relativeTo(File $receiver, @NotNull File base) {
        int i;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(base, "base");
        FilePathComponents components = FilesKt.filePathComponents($receiver);
        FilePathComponents baseComponents = FilesKt.filePathComponents(base);
        if (Intrinsics.areEqual(components.getRootName(), baseComponents.getRootName()) ^ true) {
            throw (Throwable)new IllegalArgumentException("this and base files have different roots: " + components.getRootName() + " and " + baseComponents.getRootName());
        }
        for (i = 0; i < components.size() && i < baseComponents.size() && Intrinsics.areEqual(components.getFileList().get(i), baseComponents.getFileList().get(i)); ++i) {
        }
        int sameCount = i;
        int baseCount = baseComponents.size();
        StringBuilder res = new StringBuilder();
        int n = sameCount;
        int n2 = baseCount - 2;
        if (n <= n2) {
            while (true) {
                void j;
                res.append("..").append(File.separator);
                if (j == n2) break;
                ++j;
            }
        }
        if (baseCount > sameCount) {
            res.append(sameCount < components.size() ? ".." + File.separator : "..");
        }
        if (sameCount < components.size() - 1) {
            res.append(components.subPath(sameCount, components.size() - 1)).append(File.separator);
        }
        if (sameCount < components.size()) {
            res.append(components.subPath(components.size() - 1, components.size()));
        }
        String string = res.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "res.toString()");
        return string;
    }

    @Deprecated(message="Use relativeTo() function instead")
    @NotNull
    public static final String relativePath(File $receiver, @NotNull File descendant) {
        String string;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(descendant, "descendant");
        String prefix = FilesKt.getDirectory($receiver).getCanonicalPath();
        String answer = descendant.getCanonicalPath();
        String string2 = prefix;
        Intrinsics.checkExpressionValueIsNotNull(string2, "prefix");
        if (StringsKt.startsWith$default(answer, string2, false, 2)) {
            int prefixSize = CollectionsKt.length(prefix);
            string = CollectionsKt.length(answer) > prefixSize ? StringsKt.substring(answer, prefixSize + 1) : "";
        } else {
            string = answer;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final long copyTo(File $receiver, @NotNull File dst, boolean overwrite, int bufferSize) {
        long l;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(dst, "dst");
        if (!$receiver.exists()) {
            throw (Throwable)new NoSuchFileException($receiver, null, "The source file doesn't exist", 2, null);
        }
        if ($receiver.isDirectory()) {
            throw (Throwable)new IllegalArgumentException("Use copyRecursively to copy a directory " + $receiver);
        }
        if (dst.exists()) {
            if (!overwrite) {
                throw (Throwable)new FileAlreadyExistsException($receiver, dst, "The destination file already exists");
            }
            if (dst.isDirectory() && ArraysKt.any((Object[])dst.listFiles())) {
                String string = $receiver.getName();
                Intrinsics.checkExpressionValueIsNotNull(string, "name");
                return FilesKt.copyTo($receiver, FilesKt.resolve(dst, string), overwrite, bufferSize);
            }
        }
        File file = dst.getParentFile();
        Boolean bl = file != null ? Boolean.valueOf(file.mkdirs()) : null;
        dst.delete();
        FileInputStream input = new FileInputStream($receiver);
        Closeable closeable = input;
        boolean closed = false;
        try {
            Long l2;
            void $receiver3;
            FileInputStream it2 = (FileInputStream)$receiver2;
            FileOutputStream output = new FileOutputStream(dst);
            Closeable closeable2 = output;
            boolean closed2 = false;
            try {
                FileOutputStream it3 = (FileOutputStream)$receiver3;
                l2 = ByteStreamsKt.copyTo(input, output, bufferSize);
            }
            catch (Exception e) {
                closed2 = true;
                try {
                    $receiver3.close();
                }
                catch (Exception closeException) {
                    // empty catch block
                }
                throw (Throwable)e;
            }
            finally {
                if (!closed2) {
                    $receiver3.close();
                }
            }
            l = ((Number)l2).longValue();
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver2.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            if (!closed) {
                $receiver2.close();
            }
        }
        return l;
    }

    public static /* bridge */ /* synthetic */ long copyTo$default(File file, File file2, boolean bl, int n, int n2) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = FilesKt.getDefaultBufferSize();
        }
        return FilesKt.copyTo(file, file2, bl, n);
    }

    public static final boolean copyRecursively(File $receiver, @NotNull File dst, @NotNull Function2<? super File, ? super IOException, ? extends OnErrorAction> onError) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(dst, "dst");
        Intrinsics.checkParameterIsNotNull(onError, "onError");
        if (!$receiver.exists()) {
            return Intrinsics.areEqual((Object)onError.invoke($receiver, new NoSuchFileException($receiver, null, "The source file doesn't exist", 2, null)), (Object)OnErrorAction.TERMINATE) ^ true;
        }
        try {
            Iterator<File> iterator2 = FilesKt.walkTopDown($receiver).fail((Function2<? super File, ? super IOException, ? extends Unit>)new Function2<File, IOException, Unit>(onError){
                final /* synthetic */ Function2 $onError;

                public final void invoke(@NotNull File f, @NotNull IOException e) {
                    Intrinsics.checkParameterIsNotNull(f, "f");
                    Intrinsics.checkParameterIsNotNull(e, "e");
                    if (Intrinsics.areEqual((Object)((Object)((OnErrorAction)((Object)this.$onError.invoke(f, e)))), (Object)((Object)OnErrorAction.TERMINATE))) {
                        throw (Throwable)new TerminateException(f);
                    }
                }
                {
                    this.$onError = function2;
                    super(2);
                }
            }).iterator();
            while (iterator2.hasNext()) {
                File src = iterator2.next();
                if (!src.exists()) {
                    if (!Intrinsics.areEqual((Object)onError.invoke(src, new NoSuchFileException(src, null, "The source file doesn't exist", 2, null)), (Object)OnErrorAction.TERMINATE)) continue;
                    return false;
                }
                String relPath = FilesKt.relativeTo(src, $receiver);
                File dstFile = new File(dst, relPath);
                if (!(!dstFile.exists() || src.isDirectory() && dstFile.isDirectory())) {
                    if (!Intrinsics.areEqual((Object)onError.invoke(dstFile, new FileAlreadyExistsException(src, dstFile, "The destination file already exists")), (Object)OnErrorAction.TERMINATE)) continue;
                    return false;
                }
                if (src.isDirectory()) {
                    dstFile.mkdirs();
                    continue;
                }
                if (FilesKt.copyTo$default(src, dstFile, true, 0, 4) == src.length() || !Intrinsics.areEqual((Object)onError.invoke(src, new IOException("src.length() != dst.length()")), (Object)OnErrorAction.TERMINATE)) continue;
                return false;
            }
            return true;
        }
        catch (TerminateException e) {
            return false;
        }
    }

    public static /* bridge */ /* synthetic */ boolean copyRecursively$default(File file, File file2, Function2 function2, int n) {
        if ((n & 2) != 0) {
            function2 = copyRecursively.1.INSTANCE;
        }
        return FilesKt.copyRecursively(file, file2, function2);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean deleteRecursively(File $receiver) {
        void var3_3;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Sequence sequence2 = FilesKt.walkBottomUp($receiver);
        boolean initial = $receiver.exists();
        boolean accumulator = initial;
        for (Object element : $receiver2) {
            void it2;
            File file = (File)element;
            boolean res = accumulator;
            accumulator = it2.delete() && res;
        }
        return (boolean)var3_3;
    }

    @Nullable
    public static final File[] listFiles(File $receiver, @NotNull Function1<? super File, ? extends Boolean> filter) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(filter, "filter");
        Function1<? super File, ? extends Boolean> function1 = filter;
        return $receiver.listFiles((FileFilter)(function1 == null ? null : new FilesKt__UtilsKt$sam$FileFilter$ace751fe(function1)));
    }

    public static final boolean startsWith(File $receiver, @NotNull File other) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(other, "other");
        FilePathComponents components = FilesKt.filePathComponents($receiver);
        FilePathComponents otherComponents = FilesKt.filePathComponents(other);
        if (Intrinsics.areEqual(components.getRootName(), otherComponents.getRootName()) ^ true && Intrinsics.areEqual(otherComponents.getRootName(), "") ^ true) {
            return false;
        }
        return components.size() < otherComponents.size() ? false : ((Object)components.getFileList().subList(0, otherComponents.size())).equals(otherComponents.getFileList());
    }

    public static final boolean startsWith(File $receiver, @NotNull String other) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(other, "other");
        return FilesKt.startsWith($receiver, new File(other));
    }

    public static final boolean endsWith(File $receiver, @NotNull File other) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(other, "other");
        FilePathComponents components = FilesKt.filePathComponents($receiver);
        FilePathComponents otherComponents = FilesKt.filePathComponents(other);
        if (Intrinsics.areEqual(components.getRootName(), otherComponents.getRootName()) ^ true && Intrinsics.areEqual(otherComponents.getRootName(), "") ^ true) {
            return false;
        }
        int shift = components.size() - otherComponents.size();
        return shift < 0 ? false : ((Object)components.getFileList().subList(shift, components.size())).equals(otherComponents.getFileList());
    }

    public static final boolean endsWith(File $receiver, @NotNull String other) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(other, "other");
        return FilesKt.endsWith($receiver, new File(other));
    }

    @NotNull
    public static final File normalize(File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        FilePathComponents components = FilesKt.filePathComponents($receiver);
        String rootName = components.getRootName();
        List list = new ArrayList();
        for (File file : components.getFileList()) {
            String name;
            switch (name = file.toString()) {
                case "..": {
                    if (!list.isEmpty()) {
                        Collection $receiver2;
                        Collection collection = list;
                        List list2 = list;
                        int n = $receiver2.size();
                        if (Intrinsics.areEqual((String)list2.get(n - 1), "..") ^ true) {
                            $receiver2 = list;
                            list2 = list;
                            n = $receiver2.size();
                            CollectionsKt.remove(list2, n - 1);
                            break;
                        }
                    }
                    String string = name;
                    Intrinsics.checkExpressionValueIsNotNull(string, "name");
                    list.add(string);
                    break;
                }
                default: {
                    String string = name;
                    Intrinsics.checkExpressionValueIsNotNull(string, "name");
                    list.add(string);
                }
                case ".": 
            }
        }
        Iterable iterable = list;
        CharSequence charSequence = File.separator;
        Intrinsics.checkExpressionValueIsNotNull(charSequence, "File.separator");
        return new File(CollectionsKt.joinToString$default(iterable, charSequence, (CharSequence)rootName, null, 0, null, null, 60));
    }

    @NotNull
    public static final File resolve(File $receiver, @NotNull File relative) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(relative, "relative");
        if (FilesKt.getRoot(relative) != null) {
            return relative;
        }
        String ourName = $receiver.toString();
        return StringsKt.endsWith$default((CharSequence)ourName, File.separatorChar, false, 2) ? new File(ourName + relative) : new File(ourName + File.separatorChar + relative);
    }

    @NotNull
    public static final File resolve(File $receiver, @NotNull String relative) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(relative, "relative");
        return FilesKt.resolve($receiver, new File(relative));
    }

    @NotNull
    public static final File resolveSibling(File $receiver, @NotNull File relative) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(relative, "relative");
        FilePathComponents components = FilesKt.filePathComponents($receiver);
        String rootName = components.getRootName();
        return components.size() == 0 ? relative : FilesKt.resolve(FilesKt.resolve(new File(rootName), components.subPath(0, components.size() - 1)), relative);
    }

    @NotNull
    public static final File resolveSibling(File $receiver, @NotNull String relative) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(relative, "relative");
        return FilesKt.resolveSibling($receiver, new File(relative));
    }
}

