# Module stdlib

## Kotlin Standard Library

The Kotlin standard library is a set of functions and types implementing idiomatic patterns when working with collections,
text and files.

# Package kotlin

Core functions and types, available on all supported platforms.

# Package kotlin.annotation

Library support for the Kotlin annotation facility.

# Package kotlin.browser

API to access the web browser DOM.

# Package kotlin.concurrent

Utility functions for concurrent programming.

# Package kotlin.dom

Functions for working with the W3C DOM.

# Package kotlin.jvm

Functions and annotations specific to the Java platform.

# Package kotlin.io

IO API for working with files and streams.

# Package kotlin.math

Mathematics API.

# Package kotlin.platform

APIs for customizing the code generated by the Kotlin compiler for better interoperability with
other code on the target platform.

# Package kotlin.properties

Standard implementations of delegates for [delegated properties](/docs/reference/delegated-properties.html)
and helper functions for implementing custom delegates.

# Package kotlin.reflect

Runtime API for [Kotlin reflection](/docs/reference/reflection.html)

# Package kotlin.reflect.jvm

Runtime API for interoperability between [Kotlin reflection](/docs/reference/reflection.html) and
Java reflection.

# Package kotlin.test

Functions for writing tests.

# Package kotlin.text

Functions for working with text and regular expressions.

# Package kotlin.util

Utility functions.
