/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command.conflict;

import java.util.Collection;
import javax.swing.Icon;
import org.openstreetmap.josm.command.conflict.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class VersionConflictResolveCommand
extends ConflictResolveCommand {
    private final Conflict<? extends OsmPrimitive> conflict;

    public VersionConflictResolveCommand(Conflict<? extends OsmPrimitive> conflict) {
        this.conflict = conflict;
    }

    @Override
    public String getDescriptionText() {
        String string = "";
        switch (OsmPrimitiveType.from(this.conflict.getMy())) {
            case NODE: {
                string = I18n.marktr("Resolve version conflict for node {0}");
                break;
            }
            case WAY: {
                string = I18n.marktr("Resolve version conflict for way {0}");
                break;
            }
            case RELATION: {
                string = I18n.marktr("Resolve version conflict for relation {0}");
            }
        }
        return I18n.tr(string, this.conflict.getMy().getId());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "object");
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        if (!this.conflict.getMy().isNew()) {
            long l = this.conflict.getMy().getVersion();
            long l2 = this.conflict.getTheir().getVersion();
            this.conflict.getMy().setOsmId(this.conflict.getMy().getId(), (int)Math.max(l, l2));
            if (l2 >= l) {
                this.conflict.getMy().setVisible(this.conflict.getTheir().isVisible());
            }
        }
        this.getLayer().getConflicts().remove(this.conflict);
        this.rememberConflict(this.conflict);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.conflict.getMy());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.conflict == null ? 0 : this.conflict.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        VersionConflictResolveCommand versionConflictResolveCommand = (VersionConflictResolveCommand)object;
        return !(this.conflict == null ? versionConflictResolveCommand.conflict != null : !this.conflict.equals(versionConflictResolveCommand.conflict));
    }
}

