/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;

public class RelationMemberData
implements PrimitiveId {
    private final String role;
    private final long memberId;
    private final OsmPrimitiveType memberType;

    public RelationMemberData(String string, OsmPrimitiveType osmPrimitiveType, long l) {
        this.role = string == null ? "" : string;
        this.memberType = osmPrimitiveType;
        this.memberId = l;
    }

    public RelationMemberData(String string, PrimitiveId primitiveId) {
        this(string, primitiveId.getType(), primitiveId.getUniqueId());
    }

    public long getMemberId() {
        return this.memberId;
    }

    public String getRole() {
        return this.role;
    }

    public OsmPrimitiveType getMemberType() {
        return this.memberType;
    }

    public boolean hasRole() {
        return !"".equals(this.role);
    }

    public String toString() {
        return (this.memberType != null ? this.memberType.getAPIName() : "undefined") + ' ' + this.memberId;
    }

    @Override
    public OsmPrimitiveType getType() {
        return this.memberType;
    }

    @Override
    public long getUniqueId() {
        return this.memberId;
    }

    @Override
    public boolean isNew() {
        return this.memberId <= 0L;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (int)(this.memberId ^ this.memberId >>> 32);
        n = 31 * n + (this.memberType == null ? 0 : this.memberType.hashCode());
        n = 31 * n + (this.role == null ? 0 : this.role.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RelationMemberData relationMemberData = (RelationMemberData)object;
        if (this.memberId != relationMemberData.memberId) {
            return false;
        }
        if (this.memberType != relationMemberData.memberType) {
            return false;
        }
        return !(this.role == null ? relationMemberData.role != null : !this.role.equals(relationMemberData.role));
    }
}

