/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.history.HistoryNameFormatter;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class HistoryWay
extends HistoryOsmPrimitive {
    private List<Long> nodeIds = new ArrayList<Long>();

    public HistoryWay(long l, long l2, boolean bl, User user, long l3, Date date) {
        super(l, l2, bl, user, l3, date);
    }

    public HistoryWay(long l, long l2, boolean bl, User user, long l3, Date date, boolean bl2) {
        super(l, l2, bl, user, l3, date, bl2);
    }

    public HistoryWay(long l, long l2, boolean bl, User user, long l3, Date date, List<Long> list) {
        this(l, l2, bl, user, l3, date);
        CheckParameterUtil.ensureParameterNotNull(list, "nodeIdList");
        this.nodeIds.addAll(list);
    }

    public HistoryWay(Way way) {
        super(way);
    }

    public int getNumNodes() {
        return this.nodeIds.size();
    }

    public long getNodeId(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.nodeIds.size()) {
            throw new IndexOutOfBoundsException(I18n.tr("Parameter {0} not in range 0..{1}. Got ''{2}''.", "idx", this.nodeIds.size(), n));
        }
        return this.nodeIds.get(n);
    }

    public List<Long> getNodes() {
        return Collections.unmodifiableList(this.nodeIds);
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.WAY;
    }

    public void addNode(long l) {
        this.nodeIds.add(l);
    }

    public boolean isClosed() {
        return this.getNumNodes() >= 3 && this.nodeIds.get(0) == this.nodeIds.get(this.nodeIds.size() - 1);
    }

    @Override
    public String getDisplayName(HistoryNameFormatter historyNameFormatter) {
        return historyNameFormatter.format(this);
    }
}

