/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.StyleSetting;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public abstract class StyleSource
extends SourceEntry {
    private List<Throwable> errors = new ArrayList<Throwable>();
    public File zipIcons;
    private ImageProvider imageIconProvider;
    private static ImageProvider defaultIconProvider;
    public String icon;
    public final List<StyleSetting> settings = new ArrayList<StyleSetting>();
    public Map<String, Object> settingValues = new HashMap<String, Object>();

    public StyleSource(String string, String string2, String string3) {
        super(string, string2, string3, true);
    }

    public StyleSource(SourceEntry sourceEntry) {
        super(sourceEntry);
    }

    public abstract void apply(MultiCascade var1, OsmPrimitive var2, double var3, boolean var5);

    public abstract void loadStyleSource();

    public abstract InputStream getSourceInputStream() throws IOException;

    public abstract CachedFile getCachedFile() throws IOException;

    public void closeSourceInputStream(InputStream inputStream) {
        Utils.close(inputStream);
    }

    public void logError(Throwable throwable) {
        this.errors.add(throwable);
    }

    public Collection<Throwable> getErrors() {
        return Collections.unmodifiableCollection(this.errors);
    }

    protected void init() {
        this.errors.clear();
        this.imageIconProvider = null;
        this.icon = null;
    }

    private static synchronized ImageProvider getDefaultIconProvider() {
        if (defaultIconProvider == null) {
            defaultIconProvider = new ImageProvider("dialogs/mappaint", "pencil");
        }
        return defaultIconProvider;
    }

    protected ImageProvider getSourceIconProvider() {
        if (this.imageIconProvider == null) {
            if (this.icon != null) {
                this.imageIconProvider = MapPaintStyles.getIconProvider(new MapPaintStyles.IconReference(this.icon, this), true);
            }
            if (this.imageIconProvider == null) {
                this.imageIconProvider = StyleSource.getDefaultIconProvider();
            }
        }
        return this.imageIconProvider;
    }

    public final ImageProvider getIconProvider() {
        ImageProvider imageProvider = this.getSourceIconProvider();
        if (!this.getErrors().isEmpty()) {
            imageProvider = new ImageProvider(imageProvider).addOverlay(new ImageOverlay(new ImageProvider("dialogs/mappaint/error_small")));
        }
        return imageProvider;
    }

    public final ImageIcon getIcon() {
        return this.getIconProvider().setMaxSize(ImageProvider.ImageSizes.MENU).get();
    }

    public String getToolTipText() {
        if (this.errors.isEmpty()) {
            return null;
        }
        return I18n.trn("There was an error when loading this style. Select ''Info'' from the right click menu for details.", "There were {0} errors when loading this style. Select ''Info'' from the right click menu for details.", this.errors.size(), this.errors.size());
    }

    public Color getBackgroundColorOverride() {
        return null;
    }
}

