/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.engine.stats.behavior.ICacheStats;
import org.apache.commons.jcs.engine.stats.behavior.IStatElement;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.layer.WMTSLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public class CacheContentsPanel
extends JPanel {
    private final transient ExecutorService executor = Executors.newSingleThreadExecutor(Utils.newThreadFactory(this.getClass() + "-%d", 5));

    public CacheContentsPanel() {
        super(new GridBagLayout());
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                CacheContentsPanel.this.addToPanel(TMSLayer.getCache(), "TMS");
                CacheContentsPanel.this.addToPanel(WMSLayer.getCache(), "WMS");
                CacheContentsPanel.this.addToPanel(WMTSLayer.getCache(), "WMTS");
            }
        });
        this.executor.shutdown();
    }

    private void addToPanel(final CacheAccess<String, BufferedImageCacheEntry> cacheAccess, final String string) {
        final Long l = CacheContentsPanel.getCacheSize(cacheAccess);
        final DefaultTableModel defaultTableModel = CacheContentsPanel.getTableModel(cacheAccess);
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                CacheContentsPanel.this.add((Component)new JLabel(I18n.tr("{0} cache, total cache size: {1} bytes", string, l)), GBC.eol().insets(5, 5, 0, 0));
                CacheContentsPanel.this.add((Component)new JScrollPane(CacheContentsPanel.this.getTableForCache(cacheAccess, defaultTableModel)), GBC.eol().fill(1));
            }
        });
    }

    private static Long getCacheSize(CacheAccess<String, BufferedImageCacheEntry> cacheAccess) {
        ICacheStats iCacheStats = cacheAccess.getStatistics();
        for (IStats iStats : iCacheStats.getAuxiliaryCacheStats()) {
            for (IStatElement<?> iStatElement : iStats.getStatElements()) {
                Object obj;
                if (!"Data File Length".equals(iStatElement.getName()) || !((obj = iStatElement.getData()) instanceof Long)) continue;
                return (Long)obj;
            }
        }
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    private static String[][] getCacheStats(CacheAccess<String, BufferedImageCacheEntry> cacheAccess) {
        Object object;
        Object object222;
        Set set = cacheAccess.getCacheControl().getKeySet();
        ConcurrentHashMap<String, int[]> concurrentHashMap = new ConcurrentHashMap<String, int[]>();
        for (Object object222 : set) {
            String[] object3 = object222.split(":", 2);
            if (object3.length == 2) {
                object = (int[])concurrentHashMap.get(object3[0]);
                if (object == null) {
                    concurrentHashMap.put(object3[0], new int[]{1});
                    continue;
                }
                object[0] = object[0] + 1;
                continue;
            }
            Main.warn("Could not parse the key: {0}. No colon found", object222);
        }
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : concurrentHashMap.entrySet()) {
            arrayList.add(new Pair(entry.getKey(), ((int[])entry.getValue())[0]));
        }
        Collections.sort(arrayList, new Comparator<Pair<String, Integer>>(){

            @Override
            public int compare(Pair<String, Integer> pair, Pair<String, Integer> pair2) {
                return -1 * ((Integer)pair.b).compareTo((Integer)pair2.b);
            }
        });
        object222 = new String[arrayList.size()][3];
        boolean bl = false;
        object = arrayList.iterator();
        while (object.hasNext()) {
            void var5_9;
            Pair pair = (Pair)object.next();
            object222[var5_9] = new String[]{(String)pair.a, ((Integer)pair.b).toString(), I18n.tr("Clear", new Object[0])};
            ++var5_9;
        }
        return object222;
    }

    private JTable getTableForCache(final CacheAccess<String, BufferedImageCacheEntry> cacheAccess, final TableModel tableModel) {
        final JTable jTable = new JTable(tableModel);
        ButtonColumn buttonColumn = new ButtonColumn(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = jTable.convertRowIndexToModel(jTable.getEditingRow());
                tableModel.setValueAt("0", n, 1);
                cacheAccess.remove(jTable.getValueAt(n, 0) + ":");
            }
        });
        TableColumn tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(buttonColumn);
        tableColumn.setCellEditor(buttonColumn);
        return jTable;
    }

    private static DefaultTableModel getTableModel(CacheAccess<String, BufferedImageCacheEntry> cacheAccess) {
        DefaultTableModel defaultTableModel = new DefaultTableModel(CacheContentsPanel.getCacheStats(cacheAccess), new String[]{I18n.tr("Cache name", new Object[0]), I18n.tr("Object Count", new Object[0]), I18n.tr("Clear", new Object[0])}){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 2;
            }
        };
        return defaultTableModel;
    }

    private static final class ButtonColumn
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor,
    ActionListener {
        private final Action action;
        private final JButton renderButton;
        private JButton editButton;
        private Object editorValue;

        private ButtonColumn(Action action) {
            this.action = action;
            this.renderButton = new JButton();
            this.editButton = new JButton();
            this.editButton.setFocusPainted(false);
            this.editButton.addActionListener(this);
            this.editButton.setBorder(new LineBorder(Color.BLUE));
        }

        @Override
        public Object getCellEditorValue() {
            return this.editorValue;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.action.actionPerformed(actionEvent);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.editorValue = object;
            if (object == null) {
                this.editButton.setText("");
                this.editButton.setIcon(null);
            } else if (object instanceof Icon) {
                this.editButton.setText("");
                this.editButton.setIcon((Icon)object);
            } else {
                this.editButton.setText(object.toString());
                this.editButton.setIcon(null);
            }
            this.editorValue = object;
            return this.editButton;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.renderButton.setForeground(jTable.getSelectionForeground());
                this.renderButton.setBackground(jTable.getSelectionBackground());
            } else {
                this.renderButton.setForeground(jTable.getForeground());
                this.renderButton.setBackground(UIManager.getColor("Button.background"));
            }
            this.renderButton.setFocusPainted(bl2);
            if (object == null) {
                this.renderButton.setText("");
                this.renderButton.setIcon(null);
            } else if (object instanceof Icon) {
                this.renderButton.setText("");
                this.renderButton.setIcon((Icon)object);
            } else {
                this.renderButton.setText(object.toString());
                this.renderButton.setIcon(null);
            }
            return this.renderButton;
        }
    }
}

