/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;

public enum TaggingPresetType {
    NODE("Mf_node", "node"),
    WAY("Mf_way", "way"),
    RELATION("Mf_relation", "relation"),
    CLOSEDWAY("Mf_closedway", "closedway");

    private final String iconName;
    private final String name;

    private TaggingPresetType(String string2, String string3) {
        this.iconName = string2 + ".svg";
        this.name = string3;
    }

    public String getIconName() {
        return this.iconName;
    }

    public String getName() {
        return this.name;
    }

    public static TaggingPresetType forPrimitive(OsmPrimitive osmPrimitive) {
        return TaggingPresetType.forPrimitiveType(osmPrimitive.getDisplayType());
    }

    public static TaggingPresetType forPrimitiveType(OsmPrimitiveType osmPrimitiveType) {
        if (osmPrimitiveType == OsmPrimitiveType.NODE) {
            return NODE;
        }
        if (osmPrimitiveType == OsmPrimitiveType.WAY) {
            return WAY;
        }
        if (osmPrimitiveType == OsmPrimitiveType.CLOSEDWAY) {
            return CLOSEDWAY;
        }
        if (osmPrimitiveType == OsmPrimitiveType.RELATION || osmPrimitiveType == OsmPrimitiveType.MULTIPOLYGON) {
            return RELATION;
        }
        throw new IllegalArgumentException("Unexpected primitive type: " + (Object)((Object)osmPrimitiveType));
    }

    public static TaggingPresetType fromString(String string) {
        for (TaggingPresetType taggingPresetType : TaggingPresetType.values()) {
            if (!taggingPresetType.getName().equals(string)) continue;
            return taggingPresetType;
        }
        return null;
    }
}

