// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var Base, Command, E, LinkTable, ST, User, add_option_dict, constants, env, format_fingerprint, iced, log, make_esc, session, tablify, timeago, util, __iced_k, __iced_k_noop,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  Base = require('./base').Base;

  log = require('../log');

  add_option_dict = require('./argparse').add_option_dict;

  session = require('../session').session;

  make_esc = require('iced-error').make_esc;

  env = require('../env').env;

  log = require('../log');

  User = require('../user').User;

  format_fingerprint = require('pgp-utils').util.format_fingerprint;

  util = require('util');

  E = require('../err').E;

  constants = require('../constants').constants;

  ST = constants.signature_types;

  tablify = require('tablify').tablify;

  timeago = require('timeago');

  LinkTable = require('../chainlink').LinkTable;

  exports.Command = Command = (function(_super) {
    __extends(Command, _super);

    function Command() {
      return Command.__super__.constructor.apply(this, arguments);
    }

    Command.prototype.OPTS = {
      r: {
        alias: 'revoked',
        action: 'storeTrue',
        help: 'show revoked signatures too'
      },
      v: {
        alias: 'verbose',
        action: 'storeTrue',
        help: 'a full dump, with more gory details'
      },
      j: {
        alias: 'json',
        action: 'storeTrue',
        help: 'output in json format; default is simple text list'
      },
      t: {
        alias: 'type',
        action: "append",
        help: 'the type of signatures to output; choose from ["track","proof","currency","self"]; all by default'
      }
    };

    Command.prototype.use_session = function() {
      return true;
    };

    Command.prototype.needs_configuration = function() {
      return true;
    };

    Command.prototype.TYPES = {
      track: ST.TRACK,
      proof: ST.REMOTE_PROOF,
      currency: ST.CRYPTOCURRENCY,
      self: ST.SELF_SIG
    };

    Command.prototype.add_subcommand_parser = function(scp) {
      var name, opts, sub;
      opts = {
        help: "list of your non-revoked signatures",
        aliases: ["list-sigs"]
      };
      name = "list-signatures";
      sub = scp.addParser(name, opts);
      sub.addArgument(["filter"], {
        nargs: '?',
        help: "a regex to filter by"
      });
      add_option_dict(sub, this.OPTS);
      return [name].concat(opts.aliases);
    };

    Command.prototype.display_json = function(list) {
      return JSON.stringify(list, null, "  ");
    };

    Command.prototype.display = function(list) {
      if (this.argv.json) {
        return this.display_json(list);
      } else {
        return this.display_text(list);
      }
    };

    Command.prototype.display_text_line = function(k, v) {
      var fields, p, proofs, _i, _len, _ref;
      fields = [k];
      if (this.argv.verbose) {
        fields.push(v.key, v.ctime);
        proofs = [];
        _ref = v.proofs;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          p = _ref[_i];
          if ((p.name != null) && (p.username != null)) {
            proofs.push("" + p.name + ":" + p.username);
          }
        }
        proofs.sort();
        fields = fields.concat(proofs);
      }
      return fields.join("\t");
    };

    Command.prototype.display_text = function(list) {
      var ctime, id, live, payload, row, rows, seqno, type;
      rows = (function() {
        var _i, _len, _ref, _results;
        _results = [];
        for (_i = 0, _len = list.length; _i < _len; _i++) {
          _ref = list[_i], seqno = _ref.seqno, id = _ref.id, type = _ref.type, ctime = _ref.ctime, live = _ref.live, payload = _ref.payload;
          row = [seqno, (this.argv.verbose ? id : id.slice(0, 9) + "..."), type, timeago(new Date(ctime * 1000))];
          if (this.argv.revoked) {
            row.push((live ? "+" : "-"));
          }
          row.push((typeof payload === 'string' ? payload : JSON.stringify(payload)));
          _results.push(row);
        }
        return _results;
      }).call(this);
      return tablify(rows, {
        row_start: ' ',
        row_end: '',
        spacer: '  ',
        row_sep_char: ''
      });
    };

    Command.prototype.filter_list = function(d) {
      var cd, k, out, proof, rps, v, _i, _len, _ref, _ref1, _ref2, _ref3, _ref4;
      if (this.filter_rxx != null) {
        out = {};
        for (k in d) {
          v = d[k];
          if (k.match(this.filter_rxx)) {
            out[k] = v;
          } else if ((rps = (_ref = v.body) != null ? (_ref1 = _ref.track) != null ? _ref1.remote_proofs : void 0 : void 0) != null) {
            for (_i = 0, _len = rps.length; _i < _len; _i++) {
              proof = rps[_i];
              if ((cd = proof != null ? (_ref2 = proof.remote_key_proof) != null ? _ref2.check_data_json : void 0 : void 0) != null) {
                if (((_ref3 = cd.username) != null ? _ref3.match(this.filter_rxx) : void 0) || ((_ref4 = cd.hostname) != null ? _ref4.match(this.filter_rxx) : void 0)) {
                  out[k] = v;
                  break;
                }
              }
            }
          }
        }
        d = out;
      }
      return d;
    };

    Command.prototype.parse_types = function(cb) {
      var err, k, t, types, _i, _len, _ref;
      types = null;
      err = null;
      if (this.argv.type != null) {
        _ref = this.argv.type;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          t = _ref[_i];
          if ((k = this.TYPES[t]) == null) {
            err = new E.ArgsError("Bad signature type specified: " + t);
            break;
          }
          types || (types = []);
          types.push(k);
        }
        if (err == null) {
          this.types = types;
        }
      }
      return cb(err);
    };

    Command.prototype.parse_args = function(cb) {
      var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "Command::parse_args");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/command/list_signatures.iced",
            funcname: "Command.parse_args"
          });
          _this.parse_filter(esc(__iced_deferrals.defer({
            lineno: 146
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/max/src/keybase/node-client/src/command/list_signatures.iced",
              funcname: "Command.parse_args"
            });
            _this.parse_types(esc(__iced_deferrals.defer({
              lineno: 147
            })));
            __iced_deferrals._fulfill();
          })(function() {
            return cb(null);
          });
        };
      })(this));
    };

    Command.prototype.parse_filter = function(cb) {
      var e, err, f;
      err = null;
      this.filter_rxx = null;
      if (((f = this.argv.filter) != null) && f.length) {
        try {
          this.filter_rxx = new RegExp(f, "i");
        } catch (_error) {
          e = _error;
          err = new E.ArgsError("Bad regex specified: " + e.message);
        }
      }
      return cb(err);
    };

    Command.prototype.select_sigs = function(me) {
      var tab;
      if ((tab = me.sig_chain.table) == null) {
        tab = new LinkTable();
      } else if (this.types != null) {
        tab = tab.select(this.types);
      }
      return tab;
    };

    Command.prototype.filter_sigs = function(tab) {
      if (this.filter_rxx != null) {
        return tab.prune((function(_this) {
          return function(obj) {
            return !(obj.matches(_this.filter_rxx));
          };
        })(this));
      }
    };

    Command.prototype.list_sigs = function(tab) {
      var list, p;
      return list = (function() {
        var _i, _len, _ref, _results;
        _ref = tab.flatten();
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          p = _ref[_i];
          _results.push(p.summary());
        }
        return _results;
      })();
    };

    Command.prototype.sort_sigs = function(list) {
      return list.sort(function(a, b) {
        return a.seqno - b.seqno;
      });
    };

    Command.prototype.process_sigs = function(me) {
      var list, tab;
      tab = this.select_sigs(me);
      this.filter_sigs(tab);
      list = this.list_sigs(tab);
      this.sort_sigs(list);
      return list;
    };

    Command.prototype.run = function(cb) {
      var esc, list, logged_in, me, un, verify_opts, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "Command::run");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/command/list_signatures.iced",
            funcname: "Command.run"
          });
          _this.parse_args(esc(__iced_deferrals.defer({
            lineno: 198
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if ((un = env().get_username()) != null) {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/max/src/keybase/node-client/src/command/list_signatures.iced",
                  funcname: "Command.run"
                });
                session.check(esc(__iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return logged_in = arguments[0];
                    };
                  })(),
                  lineno: 200
                })));
                __iced_deferrals._fulfill();
              })(function() {
                verify_opts = {
                  show_revoked: _this.argv.revoked,
                  show_perm_failures: true
                };
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/max/src/keybase/node-client/src/command/list_signatures.iced",
                    funcname: "Command.run"
                  });
                  User.load_me({
                    secret: false,
                    verify_opts: verify_opts
                  }, esc(__iced_deferrals.defer({
                    assign_fn: (function() {
                      return function() {
                        return me = arguments[0];
                      };
                    })(),
                    lineno: 202
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  list = _this.process_sigs(me);
                  list = _this.display(list);
                  return __iced_k(list.length ? log.console.log(list) : void 0);
                });
              });
            } else {
              return __iced_k(log.warn("Not logged in"));
            }
          })(function() {
            return cb(null);
          });
        };
      })(this));
    };

    return Command;

  })(Base);

}).call(this);
