// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var Config, constants, fs, iced, log, mkdirp, purge, util, __iced_k, __iced_k_noop;

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  fs = require('fs');

  log = require('./log');

  util = require('util');

  purge = require('./util').purge;

  mkdirp = require('./fs').mkdirp;

  constants = require('./constants').constants;

  exports.Config = Config = (function() {
    function Config(filename, opts) {
      this.filename = filename;
      this.opts = opts;
      this.json = null;
      this.loaded = false;
      this.cache = {};
      this.changed = false;
    }

    Config.prototype.open = function(cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      err = null;
      log.debug("+ opening config file: " + this.filename);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/config.iced",
            funcname: "Config.open"
          });
          fs.exists(_this.filename, __iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                return __slot_1.found = arguments[0];
              };
            })(_this),
            lineno: 25
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (_this.found) {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/node-client/src/config.iced",
                  funcname: "Config.open"
                });
                _this.load(__iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return err = arguments[0];
                    };
                  })(),
                  lineno: 27
                }));
                __iced_deferrals._fulfill();
              })(__iced_k);
            } else {
              return __iced_k(!_this.opts.quiet ? log.warn("No config file found; tried '" + _this.filename + "'") : void 0);
            }
          })(function() {
            log.debug("- opened config file; found=" + _this.found);
            return cb(err);
          });
        };
      })(this));
    };

    Config.prototype.is_empty = function() {
      return !(this.json != null);
    };

    Config.prototype.is_dirty = function() {
      return this.changed;
    };

    Config.prototype.unlink = function(cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/config.iced",
            funcname: "Config.unlink"
          });
          fs.unlink(_this.filename, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 41
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          log.info("Removing file: " + _this.filename);
          return cb(err);
        };
      })(this));
    };

    Config.prototype.write = function(cb) {
      var d, dat, err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      err = null;
      (function(_this) {
        return (function(__iced_k) {
          if (_this.changed) {
            _this.json = purge(_this.json);
            dat = JSON.stringify(_this.json, null, "    ");
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/config.iced",
                funcname: "Config.write"
              });
              mkdirp(_this.filename, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return d = arguments[1];
                  };
                })(),
                lineno: 52
              }));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                if (err != null) {
                  return __iced_k(log.error("Error creating directory '" + d + "': " + err.message));
                } else {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/Users/max/src/keybase/node-client/src/config.iced",
                      funcname: "Config.write"
                    });
                    fs.writeFile(_this.filename, dat, {
                      mode: constants.permissions.file
                    }, __iced_deferrals.defer({
                      assign_fn: (function() {
                        return function() {
                          return err = arguments[0];
                        };
                      })(),
                      lineno: 56
                    }));
                    __iced_deferrals._fulfill();
                  })(function() {
                    return __iced_k(err != null ? log.error("Error writing to " + _this.filename + ": " + err) : void 0);
                  });
                }
              })(function() {
                return __iced_k(err == null ? (log.info("Updated file: " + _this.filename), _this.changed = false) : void 0);
              });
            });
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    Config.prototype.get = function(key) {
      var p, parts, v, _i, _len;
      parts = key.split(".");
      v = this.json;
      for (_i = 0, _len = parts.length; _i < _len; _i++) {
        p = parts[_i];
        if (v != null) {
          v = v[p];
        }
      }
      return v;
    };

    Config.prototype.set = function(key, val) {
      var d, e, last, p, parts, _i, _len, _ref;
      parts = key.split(".");
      if (this.json == null) {
        this.json = {};
        this.changed = true;
      }
      d = this.json;
      _ref = parts.slice(0, parts.length - 1);
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        p = _ref[_i];
        if (d[p] == null) {
          d[p] = {};
          this.changed = true;
        }
        d = d[p];
      }
      last = parts.slice(-1)[0];
      e = d[last];
      if (e !== val) {
        d[last] = val;
        return this.changed = true;
      }
    };

    Config.prototype.load = function(cb) {
      var e, err, file, key, msg, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ loading config file " + this.filename);
      err = null;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/config.iced",
            funcname: "Config.load"
          });
          fs.readFile(_this.filename, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return file = arguments[1];
              };
            })(),
            lineno: 96
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          var _i, _len, _ref, _ref1;
          if (err != null) {
            log.error("Cannot read file " + _this.filename + ": " + err);
          } else {
            try {
              _this.json = JSON.parse(file);
            } catch (_error) {
              e = _error;
              log.error("Invalid json in " + _this.filename + ": " + e);
              err = e;
            }
          }
          if (err == null) {
            _ref = [];
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              key = _ref[_i];
              if (((_ref1 = _this.json) != null ? _ref1[key] : void 0) == null) {
                log.error("Missing JSON component '" + key + "' in " + _this.filename);
                err = new E.ConfigError("missing component '" + key + "'");
              }
            }
          }
          msg = _this.opts.secret ? "<redacted>" : JSON.stringify(_this.json);
          log.debug("- loaded config file -> " + msg);
          return cb(err);
        };
      })(this));
    };

    Config.prototype.obj = function() {
      return this.json;
    };

    Config.prototype.clear = function() {
      return this.json = {};
    };

    return Config;

  })();

}).call(this);
