// Generated by IcedCoffeeScript 1.7.1-f
(function() {
  var KeyInstall, KeySetup, a_json_parse, athrow, constants, fpeq, iced, keyring, keyset, log, make_esc, __iced_k, __iced_k_noop, _ref;

  iced = require('iced-runtime');
  __iced_k = __iced_k_noop = function() {};

  keyring = require('gpg-wrapper').keyring;

  constants = require('./constants').constants;

  log = require('./log');

  make_esc = require('iced-error').make_esc;

  keyset = require('../json/keyset');

  fpeq = require('pgp-utils').util.fpeq;

  _ref = require('iced-utils').util, athrow = _ref.athrow, a_json_parse = _ref.a_json_parse;

  KeyInstall = require('./key_install').KeyInstall;

  exports.KeySetup = KeySetup = (function() {
    function KeySetup(config) {
      this.config = config;
    }

    KeySetup.prototype.check_prepackaged_keyset = function(cb) {
      var a, b, body, err, esc, json, res, v, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "KeySetup::check_prepackaged_keyset");
      v = keyset.version;
      log.debug("+ KeySetup::check_prepackaged_key " + v);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-installer/src/key_setup.iced",
            funcname: "KeySetup.check_prepackaged_keyset"
          });
          _this.config.request("/sig/files/" + v + "/keyset.json", esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                res = arguments[0];
                return body = arguments[1];
              };
            })(),
            lineno: 21
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/max/src/keybase/node-installer/src/key_setup.iced",
              funcname: "KeySetup.check_prepackaged_keyset"
            });
            a_json_parse(body, esc(__iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  return json = arguments[0];
                };
              })(),
              lineno: 22
            })));
            __iced_deferrals._fulfill();
          })(function() {
            var _ref1;
            err = (a = typeof json !== "undefined" && json !== null ? json.version : void 0) !== v ? new Error("Version mismatch; expected " + v + " but got " + a) : (a = typeof json !== "undefined" && json !== null ? (_ref1 = json.keys.code) != null ? _ref1.fingerprint : void 0 : void 0) == null ? (console.log(json), new Error("Fingerprint failure; none found in server version")) : !(fpeq(a, (b = keyset.keys.code.fingerprint))) ? new Error("Fingerprint mismatch; expected " + a + " but got " + b) : null;
            log.debug("- KeySetup::check_prepackaged_keyset " + v + " -> " + err);
            return cb(err);
          });
        };
      })(this));
    };

    KeySetup.prototype.install_prepackaged_keyset = function(cb) {
      var err, keys, ki, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ Installing prepackaged keyset: v" + keyset.version);
      ki = new KeyInstall(this.config, keyset);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-installer/src/key_setup.iced",
            funcname: "KeySetup.install_prepackaged_keyset"
          });
          ki.run(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 41
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          keys = ki.keys();
          keys.version = keyset.version;
          _this.config.set_keys(keys);
          log.debug("- Installed: -> " + err);
          return cb(err);
        };
      })(this));
    };

    KeySetup.prototype.find_keyset = function(version, cb) {
      var esc, found, found_code, keys, v, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ KeySetup::find_keyset " + version);
      esc = make_esc(cb, "SetupKeyRunner::find_keyset");
      keys = {};
      found = false;
      found_code = false;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-installer/src/key_setup.iced",
            funcname: "KeySetup.find_keyset"
          });
          _this.find_key({
            which: 'code',
            version: version
          }, esc(__iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                __slot_1.code = arguments[0];
                return v = arguments[1];
              };
            })(keys),
            lineno: 56
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (keys.code != null) {
              found_code = true;
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/max/src/keybase/node-installer/src/key_setup.iced",
                  funcname: "KeySetup.find_keyset"
                });
                _this.find_key({
                  which: 'index',
                  version: v
                }, esc(__iced_deferrals.defer({
                  assign_fn: (function(__slot_1) {
                    return function() {
                      return __slot_1.index = arguments[0];
                    };
                  })(keys),
                  lineno: 59
                })));
                __iced_deferrals._fulfill();
              })(function() {
                return __iced_k(keys.index != null ? (keys.version = v, _this.config.set_keys(keys), found = true) : void 0);
              });
            } else {
              return __iced_k();
            }
          })(function() {
            log.debug("- KeySetup::find_keys " + found + " " + (typeof v !== "undefined" && v !== null ? '@ version ' + v : ''));
            return cb(null, found, keys, found_code);
          });
        };
      })(this));
    };

    KeySetup.prototype.run = function(cb) {
      var esc, found, found_code, keys, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ KeySetup::run");
      esc = make_esc(cb, "SetupKeyRunner::run");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-installer/src/key_setup.iced",
            funcname: "KeySetup.run"
          });
          _this.find_keyset(null, esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                found = arguments[0];
                keys = arguments[1];
                return found_code = arguments[2];
              };
            })(),
            lineno: 74
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (!found && found_code) {
              (function(__iced_k) {
                if (!found) {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/max/src/keybase/node-installer/src/key_setup.iced",
                      funcname: "KeySetup.run"
                    });
                    _this.find_keyset(keyset.version, esc(__iced_deferrals.defer({
                      assign_fn: (function() {
                        return function() {
                          return found = arguments[0];
                        };
                      })(),
                      lineno: 80
                    })));
                    __iced_deferrals._fulfill();
                  })(__iced_k);
                } else {
                  return __iced_k();
                }
              })(__iced_k);
            } else {
              return __iced_k();
            }
          })(function() {
            (function(__iced_k) {
              if (!found) {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/max/src/keybase/node-installer/src/key_setup.iced",
                    funcname: "KeySetup.run"
                  });
                  _this.check_prepackaged_keyset(esc(__iced_deferrals.defer({
                    lineno: 84
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/max/src/keybase/node-installer/src/key_setup.iced",
                      funcname: "KeySetup.run"
                    });
                    _this.install_prepackaged_keyset(esc(__iced_deferrals.defer({
                      lineno: 85
                    })));
                    __iced_deferrals._fulfill();
                  })(__iced_k);
                });
              } else {
                return __iced_k();
              }
            })(function() {
              log.debug("- KeySetup::run (found=" + found + ")");
              return cb(null);
            });
          });
        };
      })(this));
    };

    KeySetup.prototype.find_key = function(_arg, cb) {
      var all_keys, em, err, key, m, msg, ret, uid, v, version, wanted_key, wanted_v, which, ___iced_passed_deferral, __iced_deferrals, __iced_k, _i, _j, _len, _len1, _ref1, _ref2;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      which = _arg.which, version = _arg.version;
      log.debug("+ KeySetup::find_latest_key " + which + "@" + version);
      em = constants.uid_email[which];
      err = key = null;
      all_keys = this.config.keyring_index().lookup().email.get(em);
      wanted_key = null;
      wanted_v = null;
      ret = null;
      for (_i = 0, _len = all_keys.length; _i < _len; _i++) {
        key = all_keys[_i];
        _ref1 = key.userids();
        for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
          uid = _ref1[_j];
          if (!((m = (_ref2 = uid.comment) != null ? _ref2.match(/^v(\d+)$/) : void 0))) {
            continue;
          }
          v = parseInt(m[1], 10);
          if ((version != null) && (v === version)) {
            wanted_key = key;
            wanted_v = v;
            break;
          } else if ((version == null) && ((wanted_v != null) || v > wanted_v)) {
            wanted_key = key;
            wanted_v = v;
          }
        }
        if ((version != null) && wanted_key) {
          break;
        }
      }
      (function(_this) {
        return (function(__iced_k) {
          if (wanted_key == null) {
            msg = "No " + which + "-signing key (" + em + ") in GPG keychain";
            if (version != null) {
              msg += " (at version " + version + ")";
            }
            return __iced_k(log.warn(msg));
          } else {
            ret = _this.config.master_ring().make_key({
              fingerprint: wanted_key.fingerprint(),
              username: wanted_key.emails()[0]
            });
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/max/src/keybase/node-installer/src/key_setup.iced",
                funcname: "KeySetup.find_key"
              });
              ret.load(__iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return err = arguments[0];
                  };
                })(),
                lineno: 125
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k(err != null ? ret = null : void 0);
            });
          }
        });
      })(this)((function(_this) {
        return function() {
          log.debug("- KeySetup::find_latest_key " + which + "@" + version + " -> " + err + " / " + wanted_v + " / " + (key != null ? key.fingerprint() : void 0));
          return cb(err, ret, wanted_v);
        };
      })(this));
    };

    return KeySetup;

  })();

}).call(this);
