// Generated by IcedCoffeeScript 1.8.0-d
(function() {
  var BaseScraper, BitbucketScraper, constants, iced, v_codes, __iced_k, __iced_k_noop,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime');
  __iced_k = __iced_k_noop = function() {};

  BaseScraper = require('./base').BaseScraper;

  constants = require('../constants').constants;

  v_codes = constants.v_codes;

  exports.BitbucketScraper = BitbucketScraper = (function(_super) {
    __extends(BitbucketScraper, _super);

    function BitbucketScraper(opts) {
      this.auth = opts.auth;
      BitbucketScraper.__super__.constructor.call(this, opts);
    }

    BitbucketScraper.prototype._check_args = function(args) {
      if (!(args.username != null)) {
        return new Error("Bad args to Bitbucket proof: no username given");
      } else if (!(args.name != null) || (args.name !== 'bitbucket')) {
        return new Error("Bad args to Bitbucket proof: type is " + args.name);
      } else {
        return null;
      }
    };

    BitbucketScraper.prototype.hunt2 = function(_arg, cb) {
      var err, json, name, out, proof_text_check, rc, snippet, url, username, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      username = _arg.username, proof_text_check = _arg.proof_text_check, name = _arg.name;
      rc = v_codes.OK;
      out = {};
      if ((err = this._check_args({
        username: username,
        name: name
      })) != null) {
        return cb(err, out);
      }
      url = "https://api.bitbucket.org/2.0/snippets/" + username;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/proofs/src/scrapers/bitbucket.iced",
            funcname: "BitbucketScraper.hunt2"
          });
          _this._get_body(url, true, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                rc = arguments[1];
                return json = arguments[2];
              };
            })(),
            lineno: 33
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          _this.log("| search index " + url + " -> " + rc);
          (function(__iced_k) {
            if (rc === v_codes.OK) {
              rc = v_codes.NOT_FOUND;
              (function(__iced_k) {
                var _i, _len, _ref, _results, _while;
                _ref = json.values;
                _len = _ref.length;
                _i = 0;
                _results = [];
                _while = function(__iced_k) {
                  var _break, _continue, _next;
                  _break = function() {
                    return __iced_k(_results);
                  };
                  _continue = function() {
                    return iced.trampoline(function() {
                      ++_i;
                      return _while(__iced_k);
                    });
                  };
                  _next = function(__iced_next_arg) {
                    _results.push(__iced_next_arg);
                    return _continue();
                  };
                  if (!(_i < _len)) {
                    return _break();
                  } else {
                    snippet = _ref[_i];
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/Users/max/src/keybase/proofs/src/scrapers/bitbucket.iced",
                        funcname: "BitbucketScraper.hunt2"
                      });
                      _this._search_snippet({
                        snippet: snippet,
                        proof_text_check: proof_text_check
                      }, __iced_deferrals.defer({
                        assign_fn: (function() {
                          return function() {
                            return out = arguments[0];
                          };
                        })(),
                        lineno: 38
                      }));
                      __iced_deferrals._fulfill();
                    })(function() {
                      (function(__iced_k) {
                        if (out.rc === v_codes.OK) {
                          (function(__iced_k) {
_break()
                          })(__iced_k);
                        } else {
                          return __iced_k();
                        }
                      })(_next);
                    });
                  }
                };
                _while(__iced_k);
              })(__iced_k);
            } else {
              return __iced_k();
            }
          })(function() {
            out.rc || (out.rc = rc);
            return cb(err, out);
          });
        };
      })(this));
    };

    BitbucketScraper.prototype._check_api_url = function(_arg) {
      var api_url, rxx, username;
      api_url = _arg.api_url, username = _arg.username;
      rxx = new RegExp("^https://api.bitbucket.org/2.0/snippets/" + username + "/", "i");
      return (api_url != null) && api_url.match(rxx);
    };

    BitbucketScraper.prototype._search_snippet = function(_arg, cb) {
      var content, err, file, filename, id, json, out, proof_text_check, rc, rc2, snippet, u, ul, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      snippet = _arg.snippet, proof_text_check = _arg.proof_text_check;
      out = {};
      this.log("+ Searching snippet " + (JSON.stringify(snippet)));
      (function(_this) {
        return (function(__iced_k) {
          var _ref, _ref1;
          if ((u = snippet != null ? (_ref = snippet.links) != null ? (_ref1 = _ref.self) != null ? _ref1.href : void 0 : void 0 : void 0) == null) {
            _this.log("| snippet didn't have a URL");
            return __iced_k(rc = v_codes.FAILED_PARSE);
          } else {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/proofs/src/scrapers/bitbucket.iced",
                funcname: "BitbucketScraper._search_snippet"
              });
              _this._get_body(u, true, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    rc = arguments[1];
                    return json = arguments[2];
                  };
                })(),
                lineno: 58
              }));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                if (typeof err !== "undefined" && err !== null) {
                  _this.log("| snippet " + u + " failed to return a files list; " + (err.toString()));
                  return __iced_k(rc = v_codes.HTTP_OTHER);
                } else {
                  (function(__iced_k) {
                    if (rc !== v_codes.OK) {
                      return __iced_k(_this.log("| snippet " + u + " failed to return a files list; rc=" + rc));
                    } else {
                      (function(__iced_k) {
                        if (json.files == null) {
                          _this.log("| snippet didn't have a files section");
                          return __iced_k(rc = v_codes.FAILED_PARSE);
                        } else {
                          rc = v_codes.NOT_FOUND;
                          (function(__iced_k) {
                            var _i, _k, _keys, _ref2, _results, _while;
                            _ref2 = json.files;
                            _keys = (function() {
                              var _results1;
                              _results1 = [];
                              for (_k in _ref2) {
                                _results1.push(_k);
                              }
                              return _results1;
                            })();
                            _i = 0;
                            _results = [];
                            _while = function(__iced_k) {
                              var _break, _continue, _next, _ref3, _ref4;
                              _break = function() {
                                return __iced_k(_results);
                              };
                              _continue = function() {
                                return iced.trampoline(function() {
                                  ++_i;
                                  return _while(__iced_k);
                                });
                              };
                              _next = function(__iced_next_arg) {
                                _results.push(__iced_next_arg);
                                return _continue();
                              };
                              if (!(_i < _keys.length)) {
                                return _break();
                              } else {
                                filename = _keys[_i];
                                file = _ref2[filename];
                                if ((ul = file != null ? (_ref3 = file.links) != null ? (_ref4 = _ref3.self) != null ? _ref4.href : void 0 : void 0 : void 0) != null) {
                                  (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                      parent: ___iced_passed_deferral,
                                      filename: "/Users/max/src/keybase/proofs/src/scrapers/bitbucket.iced",
                                      funcname: "BitbucketScraper._search_snippet"
                                    });
                                    _this._get_body(ul, false, __iced_deferrals.defer({
                                      assign_fn: (function() {
                                        return function() {
                                          err = arguments[0];
                                          rc2 = arguments[1];
                                          return content = arguments[2];
                                        };
                                      })(),
                                      lineno: 70
                                    }));
                                    __iced_deferrals._fulfill();
                                  })(function() {
                                    (function(__iced_k) {
                                      if (typeof err !== "undefined" && err !== null) {
                                        return __iced_k(_this.log("| search " + filename + " (" + ul + "): " + (err.toString())));
                                      } else {
                                        (function(__iced_k) {
                                          if (rc2 !== v_codes.OK) {
                                            return __iced_k(_this.log("| search " + filename + " (" + ul + "): non-OK code " + rc2));
                                          } else {
                                            (function(__iced_k) {
                                              if ((id = _this._stripr(content).indexOf(proof_text_check)) < 0) {
                                                return __iced_k(_this.log("| search " + filename + " (" + ul + ") -> content miss"));
                                              } else {
                                                _this.log("| search " + filename + " (" + ul + ")-> found");
                                                rc = v_codes.OK;
                                                out = {
                                                  api_url: file.links.self.href,
                                                  remote_id: snippet.id,
                                                  human_url: file.links.html.href
                                                };
                                                (function(__iced_k) {
_break()
                                                })(__iced_k);
                                              }
                                            })(__iced_k);
                                          }
                                        })(__iced_k);
                                      }
                                    })(_next);
                                  });
                                } else {
                                  return _continue();
                                }
                              }
                            };
                            _while(__iced_k);
                          })(__iced_k);
                        }
                      })(__iced_k);
                    }
                  })(__iced_k);
                }
              })(__iced_k);
            });
          }
        });
      })(this)((function(_this) {
        return function() {
          _this.log("- search snippet " + u + " -> " + rc);
          out.rc = rc;
          return cb(out);
        };
      })(this));
    };

    BitbucketScraper.prototype.check_status = function(_arg, cb) {
      var api_url, err, proof_text_check, raw, rc, remote_id, username, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      username = _arg.username, api_url = _arg.api_url, proof_text_check = _arg.proof_text_check, remote_id = _arg.remote_id;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/proofs/src/scrapers/bitbucket.iced",
            funcname: "BitbucketScraper.check_status"
          });
          _this._get_body(api_url, false, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                rc = arguments[1];
                return raw = arguments[2];
              };
            })(),
            lineno: 94
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          rc = rc !== v_codes.OK ? rc : (raw.indexOf(proof_text_check)) >= 0 ? v_codes.OK : v_codes.NOT_FOUND;
          return cb(err, rc);
        };
      })(this));
    };

    BitbucketScraper.prototype._get_body = function(url, json, cb) {
      var args;
      this.log("| HTTP request for URL '" + url + "'");
      args = {
        url: url,
        auth: this.auth
      };
      if (json) {
        args.json = 1;
      }
      return this._get_url_body(args, cb);
    };

    return BitbucketScraper;

  })(BaseScraper);

}).call(this);
