# -*- coding: iso-8859-1 -*-
"""
    MoinMoin - pagelinks Formatter

    @copyright: 2005 Nir Soffer <nirs@freeshell.org>
    @license: GNU GPL, see COPYING for details.
"""

from MoinMoin.formatter import FormatterBase

class Formatter(FormatterBase):
    """ Collect pagelinks and format nothing :-) """

    def pagelink(self, on, pagename='', page=None, **kw):
        FormatterBase.pagelink(self, on, pagename, page, **kw)
        return self.null()

    def null(self, *args, **kw):
        return ''

    # All these must be overriden here because they raise
    # NotImplementedError!@#! or return html?! in the base class.
    set_highlight_re = rawHTML = url = image = smiley = text = null
    strong = emphasis = underline = highlight = sup = sub = strike = null
    code = preformatted = small = big = code_area = code_line = null
    code_token = linebreak = paragraph = rule = icon = null
    number_list = bullet_list = listitem = definition_list = null
    definition_term = definition_desc = heading = table = null
    table_row = table_cell = attachment_link = attachment_image = attachment_drawing = null
    transclusion = transclusion_param = null
    macro = lang = anchordef = span = line_anchordef = sysmsg = null
    startContent = escapedText = line_anchorlink = null
    div = endContent = anchorlink = interwikilink = null

