/*
 * Decompiled with CFR 0.152.
 */
package jcmdline;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jcmdline.AbstractParameter;
import jcmdline.CmdLineException;
import jcmdline.Strings;

public class FileParam
extends AbstractParameter {
    public static final int NO_ATTRIBUTES = 65535;
    public static final int EXISTS = 65534;
    public static final int DOESNT_EXIST = 65533;
    public static final int IS_FILE = 65531;
    public static final int IS_DIR = 65527;
    public static final int IS_READABLE = 65519;
    public static final int IS_WRITEABLE = 65503;
    public static final String DEFAULT_FILE_OPTION_LABEL = Strings.get("FileParam.defaultFileOptionLabel");
    public static final String DEFAULT_DIR_OPTION_LABEL = Strings.get("FileParam.defaultDirOptionLabel");
    private int attributes;

    public FileParam(String tag, String desc) {
        this(tag, desc, 65535, true, false, false);
    }

    public FileParam(String tag, String desc, boolean optional) {
        this(tag, desc, 65535, optional, false, false);
    }

    public FileParam(String tag, String desc, int attributes) {
        this(tag, desc, attributes, true, false, false);
    }

    public FileParam(String tag, String desc, int attributes, boolean optional) {
        this(tag, desc, attributes, optional, false, false);
    }

    public FileParam(String tag, String desc, int attributes, boolean optional, boolean multiValued) {
        this(tag, desc, attributes, optional, multiValued, false);
    }

    public FileParam(String tag, String desc, int attributes, boolean optional, boolean multiValued, boolean hidden) {
        this.setTag(tag);
        this.setAttributes(attributes);
        this.setDesc(desc);
        this.optional = optional;
        this.multiValued = multiValued;
        this.hidden = hidden;
        this.setOptionLabel(this.attrSpecified(65527) ? DEFAULT_DIR_OPTION_LABEL : DEFAULT_FILE_OPTION_LABEL);
    }

    public File getFile() {
        if (!this.set) {
            throw new RuntimeException(Strings.get("FileParam.valueNotSet", new Object[]{this.tag}));
        }
        return new File((String)this.values.get(0));
    }

    public Collection getFiles() {
        ArrayList<File> vals = new ArrayList<File>(this.values.size());
        Iterator itr = this.values.iterator();
        while (itr.hasNext()) {
            vals.add(new File((String)itr.next()));
        }
        return vals;
    }

    public void validateValue(String val) throws CmdLineException {
        super.validateValue(val);
        File f = null;
        try {
            f = new File(val);
        }
        catch (Exception e) {
            this.throwIllegalValueException(val);
        }
        if (this.attrSpecified(65527) && !f.isDirectory()) {
            this.throwIllegalValueException(val);
        }
        if (this.attrSpecified(65531) && !f.isFile()) {
            this.throwIllegalValueException(val);
        }
        if (this.attrSpecified(65534) && !f.exists()) {
            this.throwIllegalValueException(val);
        }
        if (this.attrSpecified(65533) && f.exists()) {
            this.throwIllegalValueException(val);
        }
        if (this.attrSpecified(65519) && !f.canRead()) {
            this.throwIllegalValueException(val);
        }
        if (this.attrSpecified(65503) && !f.canWrite()) {
            this.throwIllegalValueException(val);
        }
    }

    public boolean attrSpecified(int attr) {
        if (attr != 65534 && attr != 65535 && attr != 65533 && attr != 65527 && attr != 65531 && attr != 65519 && attr != 65503) {
            return false;
        }
        return ((this.attributes | attr) ^ 0xFFFF) != 0;
    }

    public void setAttributes(int attributes) {
        if ((attributes ^ 0xFFFF) >= 64) {
            throw new IllegalArgumentException(Strings.get("FileParam.invalidAttributes", new Object[]{new Integer(attributes)}));
        }
        this.attributes = attributes;
    }

    public int getAttributes() {
        return this.attributes;
    }

    private void throwIllegalValueException(String val) throws CmdLineException {
        String s1 = this.attrSpecified(65527) ? Strings.get("FileParam.directory") : (this.attrSpecified(65531) ? Strings.get("FileParam.file") : Strings.get("FileParam.file_dir"));
        String s2 = this.attrSpecified(65534) || this.attrSpecified(65527) || this.attrSpecified(65531) || this.attrSpecified(65519) || this.attrSpecified(65503) ? Strings.get("FileParam.an_existing") : Strings.get("FileParam.a");
        String s3 = "";
        if (this.attrSpecified(65519)) {
            s3 = this.attrSpecified(65503) ? Strings.get("FileParam.readable_writeable") : Strings.get("FileParam.readable");
        } else if (this.attrSpecified(65503)) {
            s3 = Strings.get("FileParam.writeable");
        }
        throw new CmdLineException(Strings.get("FileParam.illegalValue", new Object[]{s2, s1, s3, val, this.tag}));
    }
}

