/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.AuthenticatedData;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.PasswordRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.KEKRecipientInformation;
import org.bouncycastle.cms.KeyAgreeRecipientInformation;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.PasswordRecipientInformation;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.util.Arrays;

public class CMSAuthenticatedData {
    RecipientInformationStore recipientInfoStore;
    ContentInfo contentInfo;
    private AlgorithmIdentifier macAlg;
    private ASN1Set authAttrs;
    private ASN1Set unauthAttrs;
    private byte[] mac;

    public CMSAuthenticatedData(byte[] byArray) throws CMSException {
        this(CMSUtils.readContentInfo(byArray));
    }

    public CMSAuthenticatedData(InputStream inputStream) throws CMSException {
        this(CMSUtils.readContentInfo(inputStream));
    }

    public CMSAuthenticatedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        AuthenticatedData authenticatedData = AuthenticatedData.getInstance((Object)contentInfo.getContent());
        ContentInfo contentInfo2 = authenticatedData.getEncapsulatedContentInfo();
        this.macAlg = authenticatedData.getMacAlgorithm();
        this.mac = authenticatedData.getMac().getOctets();
        ASN1Set aSN1Set = authenticatedData.getRecipientInfos();
        ArrayList<RecipientInformation> arrayList = new ArrayList<RecipientInformation>();
        byte[] byArray = ASN1OctetString.getInstance((Object)contentInfo2.getContent()).getOctets();
        for (int i = 0; i != aSN1Set.size(); ++i) {
            RecipientInfo recipientInfo = RecipientInfo.getInstance((Object)aSN1Set.getObjectAt(i));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DEREncodable dEREncodable = recipientInfo.getInfo();
            if (dEREncodable instanceof KeyTransRecipientInfo) {
                arrayList.add(new KeyTransRecipientInformation((KeyTransRecipientInfo)dEREncodable, null, this.macAlg, (InputStream)byteArrayInputStream));
                continue;
            }
            if (dEREncodable instanceof KEKRecipientInfo) {
                arrayList.add(new KEKRecipientInformation((KEKRecipientInfo)dEREncodable, null, this.macAlg, (InputStream)byteArrayInputStream));
                continue;
            }
            if (dEREncodable instanceof KeyAgreeRecipientInfo) {
                arrayList.add(new KeyAgreeRecipientInformation((KeyAgreeRecipientInfo)dEREncodable, null, this.macAlg, (InputStream)byteArrayInputStream));
                continue;
            }
            if (!(dEREncodable instanceof PasswordRecipientInfo)) continue;
            arrayList.add(new PasswordRecipientInformation((PasswordRecipientInfo)dEREncodable, null, this.macAlg, (InputStream)byteArrayInputStream));
        }
        this.authAttrs = authenticatedData.getAuthAttrs();
        this.recipientInfoStore = new RecipientInformationStore(arrayList);
        this.unauthAttrs = authenticatedData.getUnauthAttrs();
    }

    public byte[] getMac() {
        return Arrays.clone((byte[])this.mac);
    }

    private byte[] encodeObj(DEREncodable dEREncodable) throws IOException {
        if (dEREncodable != null) {
            return dEREncodable.getDERObject().getEncoded();
        }
        return null;
    }

    public String getMacAlgOID() {
        return this.macAlg.getObjectId().getId();
    }

    public byte[] getMacAlgParams() {
        try {
            return this.encodeObj(this.macAlg.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public AlgorithmParameters getMacAlgorithmParameters(String string) throws CMSException, NoSuchProviderException {
        return this.getMacAlgorithmParameters(CMSUtils.getProvider(string));
    }

    public AlgorithmParameters getMacAlgorithmParameters(Provider provider) throws CMSException {
        return CMSEnvelopedHelper.INSTANCE.getEncryptionAlgorithmParameters(this.getMacAlgOID(), this.getMacAlgParams(), provider);
    }

    public RecipientInformationStore getRecipientInfos() {
        return this.recipientInfoStore;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public AttributeTable getAuthAttrs() {
        if (this.authAttrs == null) {
            return null;
        }
        return new AttributeTable(this.authAttrs);
    }

    public AttributeTable getUnauthAttrs() {
        if (this.unauthAttrs == null) {
            return null;
        }
        return new AttributeTable(this.unauthAttrs);
    }

    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }
}

