/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.IAuthenticationHandler;
import de.intarsys.pdf.crypt.ISecurityHandler;
import de.intarsys.pdf.crypt.PasswordProvider;
import de.intarsys.pdf.crypt.StandardSecurityHandler;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.string.CharacterTools;
import de.intarsys.tools.string.StringTools;

public class StandardAuthenticationHandler
implements IAuthenticationHandler {
    private IPasswordProvider passwordProvider;
    private int retries = 3;
    private boolean useDefaultAuthentication = true;

    @Override
    public void authenticate(ISecurityHandler iSecurityHandler) throws COSSecurityException {
        if (!(iSecurityHandler instanceof StandardSecurityHandler)) {
            throw new COSSecurityException("security handler not supported");
        }
        StandardSecurityHandler standardSecurityHandler = (StandardSecurityHandler)iSecurityHandler;
        if (this.isUseDefaultAuthentication() && standardSecurityHandler.authenticateUser(null)) {
            return;
        }
        STDocument sTDocument = iSecurityHandler.stGetDoc();
        char[] cArray = PasswordProvider.getPassword(sTDocument);
        if (cArray != null) {
            if (!this.authenticate(standardSecurityHandler, cArray)) {
                throw new COSSecurityException("wrong password");
            }
        } else {
            IPasswordProvider iPasswordProvider = PasswordProvider.getPasswordProvider(sTDocument);
            if (iPasswordProvider == null) {
                iPasswordProvider = this.getPasswordProvider();
            }
            if (iPasswordProvider == null) {
                throw new COSSecurityException("password missing");
            }
            this.authenticate(standardSecurityHandler, iPasswordProvider);
        }
    }

    protected boolean authenticate(StandardSecurityHandler standardSecurityHandler, char[] cArray) throws COSSecurityException {
        byte[] byArray = CharacterTools.toByteArray((char[])cArray);
        if (standardSecurityHandler.authenticateOwner(byArray)) {
            return true;
        }
        return standardSecurityHandler.authenticateUser(byArray);
    }

    protected void authenticate(StandardSecurityHandler standardSecurityHandler, IPasswordProvider iPasswordProvider) throws COSSecurityException {
        char[] cArray = null;
        try {
            do {
                if ((cArray = iPasswordProvider.getPassword()) == null) {
                    throw new COSSecurityException("password missing");
                }
                if (this.authenticate(standardSecurityHandler, cArray)) {
                    return;
                }
                --this.retries;
            } while (this.getRetries() > 0);
            throw new COSSecurityException("wrong password");
        }
        finally {
            StringTools.clear((char[])cArray);
        }
    }

    public IPasswordProvider getPasswordProvider() {
        if (this.passwordProvider == null) {
            return PasswordProvider.get();
        }
        return this.passwordProvider;
    }

    public int getRetries() {
        return this.retries;
    }

    public boolean isUseDefaultAuthentication() {
        return this.useDefaultAuthentication;
    }

    public void setPasswordProvider(IPasswordProvider iPasswordProvider) {
        this.passwordProvider = iPasswordProvider;
    }

    public void setRetries(int n) {
        this.retries = n;
    }

    public void setUseDefaultAuthentication(boolean bl) {
        this.useDefaultAuthentication = bl;
    }
}

