/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.number;

import de.intarsys.tools.number.NumberInstance;
import de.intarsys.tools.number.NumberInterval;
import de.intarsys.tools.number.NumberList;
import de.intarsys.tools.number.NumberWrapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class NumberParser {
    private final boolean integer;

    public static NumberWrapper parse(String string) throws IOException {
        if (string == null) {
            return null;
        }
        return new NumberParser(false).parse(new StringReader(string));
    }

    public static NumberWrapper parseInteger(String string) throws IOException {
        if (string == null) {
            return null;
        }
        return new NumberParser(true).parse(new StringReader(string));
    }

    protected NumberParser(boolean bl) {
        this.integer = bl;
    }

    public boolean isInteger() {
        return this.integer;
    }

    protected boolean isIntervalSeparator(char c) {
        return c == NumberInterval.SEPARATOR;
    }

    protected boolean isListSeparator(char c) {
        return c == NumberList.SEPARATOR;
    }

    protected boolean isNumberChar(char c) {
        return c == '.' || c >= '0' || c <= '9' || c == '-' || c == '+' || c == ',' && !this.isInteger();
    }

    protected NumberWrapper parse(StringReader stringReader) throws IOException {
        NumberList numberList = new NumberList();
        this.parse(stringReader, numberList);
        return numberList;
    }

    protected void parse(StringReader stringReader, NumberList numberList) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        Double d = null;
        NumberInterval numberInterval = null;
        int n = stringReader.read();
        while (n > -1) {
            char c = (char)n;
            if (!Character.isWhitespace(c)) {
                if (this.isListSeparator(c)) {
                    if (numberInterval != null) {
                        if (numberInterval.getTo() == null) {
                            throw new IOException("number expected");
                        }
                        numberList.add(numberInterval);
                        numberInterval = null;
                        d = null;
                    } else if (d != null) {
                        numberList.add(new NumberInstance(d));
                        d = null;
                    }
                } else if (d != null && c == '-') {
                    numberInterval = new NumberInterval();
                    numberInterval.setFrom(d);
                    d = null;
                } else if (this.isNumberChar(c)) {
                    if (d != null) {
                        throw new IOException("invalid char '" + c + "'");
                    }
                    stringBuilder.setLength(0);
                    stringBuilder.append(c);
                    d = this.parseNumber(stringReader, stringBuilder);
                    if (numberInterval != null) {
                        numberInterval.setTo(d);
                    }
                }
            }
            n = stringReader.read();
        }
        if (numberInterval != null) {
            if (numberInterval.getTo() == null) {
                throw new IOException("number expected");
            }
            numberList.add(numberInterval);
        } else if (d != null) {
            numberList.add(new NumberInstance(d));
        }
    }

    protected Double parseNumber(Reader reader, StringBuilder stringBuilder) throws IOException {
        reader.mark(1);
        int n = reader.read();
        while (n != -1) {
            char c = (char)n;
            if (Character.isWhitespace(c) || this.isListSeparator(c) || this.isIntervalSeparator(c)) break;
            if (!this.isNumberChar(c)) {
                throw new IOException("invalid char '" + c + "'");
            }
            stringBuilder.append(c);
            reader.mark(1);
            n = reader.read();
        }
        reader.reset();
        try {
            return this.toNumber(stringBuilder);
        }
        catch (Exception exception) {
            throw new IOException("number format exception");
        }
    }

    protected double toNumber(StringBuilder stringBuilder) {
        return Double.parseDouble(stringBuilder.toString());
    }
}

