/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.parser.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jcmdline.BooleanParam;
import jcmdline.FileParam;
import jcmdline.IntParam;
import jcmdline.Parameter;
import jcmdline.PdfFileParam;
import jcmdline.StringParam;
import org.pdfsam.console.business.parser.handlers.interfaces.AbstractCmdHandler;

public class MixCmdHandler
extends AbstractCmdHandler {
    private static final String COMMAND_DESCRIPTION = "Mix of two pdf documents.";
    private final List mixOptions = new ArrayList<Parameter>(Arrays.asList(new FileParam("o", "pdf output file: if it doesn't exist it's created, if it exists it must be writeable", 65535, false, false), new PdfFileParam("f1", "first input pdf file to split", 65519, false, false), new PdfFileParam("f2", "second input pdf file to split", 65519, false, false), new BooleanParam("reversefirst", "reverse first input file"), new BooleanParam("reversesecond", "reverse second input file"), new IntParam("step", "step for the alternate mix (default is 1) or step for the first document if secondstep is specified.", true, false), new IntParam("secondstep", "step for second document during the alternate mix (default is 1)", true, false)));
    private static final String MIX_HELP_TEXT = "Mix alternate two pdf files. \nYou must specify '-o /home/user/out.pdf' to set the output file.\nYou must specify '-f1 /home/user/infile1.pdf' option to set the first input file (use filename:password if the file is password protected).\nYou must specify '-f2 /home/user/infile2.pdf' option to set the second input file (use filename:password if the file is password protected).\n'-reversefirst' reverse the first input file.\n'-reversesecond' reverse the second input file.\n'-step' set the step at which the mix should switch from a document to the other. This parameter is used as step for the first document if secondstep is specified. \n'-secondstep' set the step for the second document. \n";
    private static final String MIX_EXAMPLE = "Example: java -jar pdfsam-console-2.4.3e.jar -o /tmp/outfile.pdf -f1 /tmp/1.pdf -f2 /tmp/2.pdf:password -reversesecond mix\n";
    private final List mixArguments = new ArrayList<Parameter>(Arrays.asList(new StringParam("command", "command to execute {[mix]}", new String[]{"mix"}, false)));

    public Collection getArguments() {
        return this.mixArguments;
    }

    public String getHelpExamples() {
        return MIX_EXAMPLE;
    }

    public String getHelpMessage() {
        return MIX_HELP_TEXT;
    }

    public Collection getOptions() {
        return this.mixOptions;
    }

    public String getCommandDescription() {
        return COMMAND_DESCRIPTION;
    }
}

