/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.pdf.handlers;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.ListIterator;
import org.apache.log4j.Logger;
import org.pdfsam.console.business.dto.PdfFile;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.dto.commands.UnpackParsedCommand;
import org.pdfsam.console.business.pdf.handlers.interfaces.AbstractCmdExecutor;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.exceptions.console.UnpackException;
import org.pdfsam.console.utils.PdfUtility;

public class UnpackCmdExecutor
extends AbstractCmdExecutor {
    private static final Logger LOG = Logger.getLogger(UnpackCmdExecutor.class.getPackage().getName());
    private PdfReader pdfReader = null;

    public void execute(AbstractParsedCommand parsedCommand) throws ConsoleException {
        if (parsedCommand != null && parsedCommand instanceof UnpackParsedCommand) {
            UnpackParsedCommand inputCommand = (UnpackParsedCommand)parsedCommand;
            try {
                PdfFile[] fileList = this.arraysConcat(inputCommand.getInputFileList(), this.getPdfFiles(inputCommand.getInputDirectory()));
                if (fileList == null || fileList.length <= 0) {
                    throw new UnpackException(1);
                }
                for (int i = 0; i < fileList.length; ++i) {
                    int unpackedFiles = 0;
                    try {
                        ListIterator iter;
                        PdfDictionary embFiles;
                        this.pdfReader = PdfUtility.readerFor(fileList[i]);
                        this.pdfReader.removeUnusedObjects();
                        this.pdfReader.consolidateNamedDestinations();
                        PdfDictionary catalog = this.pdfReader.getCatalog();
                        PdfDictionary names = (PdfDictionary)PdfReader.getPdfObject((PdfObject)catalog.get(PdfName.NAMES));
                        if (names != null && (embFiles = (PdfDictionary)PdfReader.getPdfObject((PdfObject)names.get(new PdfName("EmbeddedFiles")))) != null) {
                            HashMap embMap = PdfNameTree.readTree((PdfDictionary)embFiles);
                            iter = embMap.values().iterator();
                            while (iter.hasNext()) {
                                PdfDictionary filespec = (PdfDictionary)PdfReader.getPdfObject((PdfObject)((PdfObject)iter.next()));
                                unpackedFiles += this.unpackFile(filespec, inputCommand.getOutputFile(), inputCommand.isOverwrite());
                            }
                        }
                        for (int k = 1; k <= this.pdfReader.getNumberOfPages(); ++k) {
                            PdfArray annots = (PdfArray)PdfReader.getPdfObject((PdfObject)this.pdfReader.getPageN(k).get(PdfName.ANNOTS));
                            if (annots == null) continue;
                            iter = annots.listIterator();
                            while (iter.hasNext()) {
                                PdfDictionary annot = (PdfDictionary)PdfReader.getPdfObject((PdfObject)((PdfObject)iter.next()));
                                PdfName subType = (PdfName)PdfReader.getPdfObject((PdfObject)annot.get(PdfName.SUBTYPE));
                                if (!PdfName.FILEATTACHMENT.equals((Object)subType)) continue;
                                PdfDictionary filespec = (PdfDictionary)PdfReader.getPdfObject((PdfObject)annot.get(PdfName.FS));
                                unpackedFiles += this.unpackFile(filespec, inputCommand.getOutputFile(), inputCommand.isOverwrite());
                            }
                        }
                        this.pdfReader.close();
                        if (unpackedFiles > 0) {
                            LOG.info("File " + fileList[i].getFile().getName() + " unpacked, found " + unpackedFiles + " attachments.");
                        } else {
                            LOG.info("No attachments in " + fileList[i].getFile().getName() + ".");
                        }
                        this.setPercentageOfWorkDone((i + 1) * 1000 / fileList.length);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error("Error unpacking file " + fileList[i].getFile().getName(), e);
                    }
                }
            }
            catch (Exception e) {
                throw new UnpackException(e);
            }
            finally {
                this.setWorkCompleted();
            }
        } else {
            throw new ConsoleException(5);
        }
    }

    public void clean() {
        this.closePdfReader(this.pdfReader);
    }

    private int unpackFile(PdfDictionary filespec, File outPath, boolean overwrite) throws IOException {
        PdfName type;
        int retVal = 0;
        if (filespec != null && (PdfName.F.equals((Object)(type = (PdfName)PdfReader.getPdfObject((PdfObject)filespec.get(PdfName.TYPE)))) || PdfName.FILESPEC.equals((Object)type))) {
            PdfDictionary ef = (PdfDictionary)PdfReader.getPdfObject((PdfObject)filespec.get(PdfName.EF));
            PdfString fn = (PdfString)PdfReader.getPdfObject((PdfObject)filespec.get(PdfName.F));
            if (fn != null && ef != null) {
                LOG.debug("Unpacking file " + fn + " to " + outPath);
                File fLast = new File(fn.toUnicodeString());
                File fullPath = new File(outPath, fLast.getName());
                if (fullPath.exists()) {
                    if (overwrite) {
                        if (!fullPath.delete()) {
                            LOG.warn("Unable to overwrite " + fullPath.getAbsolutePath() + ", unable to unpack.");
                        }
                    } else {
                        LOG.warn("Cannot overwrite " + fullPath.getAbsolutePath() + " (overwrite is false), unable to unpack.");
                    }
                } else {
                    PRStream prs = (PRStream)PdfReader.getPdfObject((PdfObject)ef.get(PdfName.F));
                    if (prs != null) {
                        byte[] b = PdfReader.getStreamBytes((PRStream)prs);
                        FileOutputStream fout = new FileOutputStream(fullPath);
                        fout.write(b);
                        fout.close();
                        retVal = 1;
                    }
                }
            }
        }
        return retVal;
    }
}

