/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.parameterdatabase.selector;

import java.util.Iterator;
import javax.swing.JComboBox;

public abstract class Selector {
    private Object value;
    private String tag;

    protected Selector(String tag, Object value) {
        this.tag = tag;
        this.value = value;
    }

    public Selector(Object value) {
        Selector selector = this.getSelectorFromValue(value);
        if (selector == null) {
            String message = "illegal value: " + value.toString();
            throw new IllegalArgumentException(message);
        }
        this.value = selector.value;
        this.tag = selector.tag;
    }

    public Selector(String tag) {
        Selector selector = this.getSelectorFromTag(tag);
        if (selector == null) {
            String message = "illegal tag: " + tag;
            throw new IllegalArgumentException(message);
        }
        this.value = selector.value;
        this.tag = selector.tag;
    }

    protected Selector getSelectorFromValue(Object value) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Selector selector = (Selector)i.next();
            try {
                if (!selector.getValue().equals(value)) continue;
                return selector;
            }
            catch (ClassCastException e) {
            }
        }
        return null;
    }

    protected Selector getSelectorFromTag(String tag) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Selector selector = (Selector)i.next();
            if (!selector.getTag().equals(tag)) continue;
            return selector;
        }
        return null;
    }

    public abstract Iterator iterator();

    public String getTag() {
        return this.tag;
    }

    public Object getValue() {
        return this.value;
    }

    public int getIntValue() {
        return (Integer)this.value;
    }

    public double getDoubleValue() {
        return (Double)this.value;
    }

    public boolean getBooleanValue() {
        return (Boolean)this.value;
    }

    public String toString() {
        return this.getTag();
    }

    public void initialize(JComboBox comboBox) {
        comboBox.removeAllItems();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            comboBox.addItem(i.next());
        }
        comboBox.setSelectedItem(this.getSelectorFromValue(this.value));
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Selector selector = (Selector)obj;
        return this.value.equals(selector.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

