/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.popup;

import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.SessionDialog;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.StructuralSiteNode;
import org.zaproxy.zap.view.ContextIncludePanel;
import org.zaproxy.zap.view.popup.PopupMenuItemSiteNodeContainer;

public class PopupMenuItemIncludeInContext
extends PopupMenuItemSiteNodeContainer {
    private static final long serialVersionUID = 990419495607725846L;
    protected Context context;

    public PopupMenuItemIncludeInContext() {
        super(Constant.messages.getString("context.new.title"), true);
        this.context = null;
        this.setPrecedeWithSeparator(true);
    }

    public PopupMenuItemIncludeInContext(Context context) {
        super(context.getName(), true);
        this.context = context;
    }

    @Override
    public String getParentMenuName() {
        return Constant.messages.getString("context.include.popup");
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    @Override
    public void performAction(SiteNode siteNode) {
        try {
            this.performAction(siteNode.getNodeName(), new StructuralSiteNode(siteNode).getRegexPattern());
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }

    protected void performAction(String string, String string2) {
        Session session = Model.getSingleton().getSession();
        if (this.context == null) {
            this.context = session.getNewContext(string);
        }
        SessionDialog sessionDialog = View.getSingleton().getSessionDialog();
        sessionDialog.recreateUISharedContexts(session);
        Context context = sessionDialog.getUISharedContext(this.context.getIndex());
        context.addIncludeInContextRegex(string2);
        View.getSingleton().showSessionDialog(session, ContextIncludePanel.getPanelName(this.context.getIndex()), false);
    }

    @Override
    public boolean isButtonEnabledForSiteNode(SiteNode siteNode) {
        if (this.context == null) {
            return true;
        }
        return !this.context.isIncluded(siteNode) && !this.context.isExcluded(siteNode);
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

