/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import com.google.common.base.Preconditions;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.support.PlainListenableActionFuture;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.ContextAndHeaderHolder;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class ActionRequestBuilder<Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> {
    protected final Action<Request, Response, RequestBuilder> action;
    protected final Request request;
    private final ThreadPool threadPool;
    protected final ElasticsearchClient client;

    protected ActionRequestBuilder(ElasticsearchClient client, Action<Request, Response, RequestBuilder> action, Request request) {
        Preconditions.checkNotNull(action, (Object)"action must not be null");
        this.action = action;
        this.request = request;
        this.client = client;
        this.threadPool = client.threadPool();
    }

    public Request request() {
        return this.request;
    }

    public final RequestBuilder putHeader(String key, Object value) {
        ((ContextAndHeaderHolder)this.request).putHeader(key, value);
        return (RequestBuilder)this;
    }

    public ListenableActionFuture<Response> execute() {
        PlainListenableActionFuture future = new PlainListenableActionFuture(this.threadPool);
        this.execute(future);
        return future;
    }

    public Response get() {
        return (Response)((ActionResponse)this.execute().actionGet());
    }

    public Response get(TimeValue timeout) {
        return (Response)((ActionResponse)this.execute().actionGet(timeout));
    }

    public Response get(String timeout) {
        return (Response)((ActionResponse)this.execute().actionGet(timeout));
    }

    public void execute(ActionListener<Response> listener) {
        this.client.execute(this.action, this.beforeExecute(this.request), listener);
    }

    protected Request beforeExecute(Request request) {
        return request;
    }
}

