/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateNonMasterUpdateTask;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.service.InternalClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.discovery.zen.NotMasterException;
import org.elasticsearch.discovery.zen.membership.MembershipAction;

public class NodeJoinController
extends AbstractComponent {
    final ClusterService clusterService;
    final RoutingService routingService;
    final DiscoverySettings discoverySettings;
    final AtomicBoolean accumulateJoins = new AtomicBoolean(false);
    final AtomicReference<ElectionContext> electionContext = new AtomicReference();
    protected final Map<DiscoveryNode, List<MembershipAction.JoinCallback>> pendingJoinRequests = new HashMap<DiscoveryNode, List<MembershipAction.JoinCallback>>();

    public NodeJoinController(ClusterService clusterService, RoutingService routingService, DiscoverySettings discoverySettings, Settings settings) {
        super(settings);
        this.clusterService = clusterService;
        this.routingService = routingService;
        this.discoverySettings = discoverySettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToBeElectedAsMaster(int requiredMasterJoins, TimeValue timeValue, ElectionCallback callback) {
        assert (this.accumulateJoins.get()) : "waitToBeElectedAsMaster is called we are not accumulating joins";
        final CountDownLatch done = new CountDownLatch(1);
        ElectionContext newContext = new ElectionContext(callback, requiredMasterJoins, this.clusterService){

            @Override
            void onClose() {
                if (NodeJoinController.this.electionContext.compareAndSet(this, null)) {
                    NodeJoinController.this.stopAccumulatingJoins("election closed");
                } else assert (false) : "failed to remove current election context";
                done.countDown();
            }
        };
        if (!this.electionContext.compareAndSet(null, newContext)) {
            this.failContext(newContext, new IllegalStateException("double waiting for election"));
            return;
        }
        try {
            this.checkPendingJoinsAndElectIfNeeded();
            try {
                if (done.await(timeValue.millis(), TimeUnit.MILLISECONDS)) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.logger.isTraceEnabled()) {
                int pendingNodes;
                Map<DiscoveryNode, List<MembershipAction.JoinCallback>> map = this.pendingJoinRequests;
                synchronized (map) {
                    pendingNodes = this.pendingJoinRequests.size();
                }
                this.logger.trace("timed out waiting to be elected. waited [{}]. pending node joins [{}]", timeValue, pendingNodes);
            }
            this.failContext(newContext, new ElasticsearchTimeoutException("timed out waiting to be elected", new Object[0]));
        }
        catch (Throwable t) {
            this.logger.error("unexpected failure while waiting for incoming joins", t, new Object[0]);
            this.failContext(newContext, "unexpected failure while waiting for pending joins", t);
        }
    }

    private void failContext(ElectionContext context, Throwable throwable) {
        this.failContext(context, throwable.getMessage(), throwable);
    }

    private void failContext(final ElectionContext context, final String reason, final Throwable throwable) {
        this.clusterService.submitStateUpdateTask("zen-disco-join(failure [" + reason + "])", Priority.IMMEDIATE, new ClusterStateNonMasterUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                context.onFailure(throwable);
                return currentState;
            }

            @Override
            public void onFailure(String source, Throwable updateFailure) {
                NodeJoinController.this.logger.warn("unexpected error while trying to fail election context due to [{}]. original exception [{}]", updateFailure, reason, throwable);
                context.onFailure(updateFailure);
            }
        });
    }

    public void startAccumulatingJoins() {
        this.logger.trace("starting to accumulate joins", new Object[0]);
        boolean b = this.accumulateJoins.getAndSet(true);
        assert (!b) : "double startAccumulatingJoins() calls";
        assert (this.electionContext.get() == null) : "startAccumulatingJoins() called, but there is an ongoing election context";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAccumulatingJoins(String reason) {
        this.logger.trace("stopping join accumulation ([{}])", reason);
        assert (this.electionContext.get() == null) : "stopAccumulatingJoins() called, but there is an ongoing election context";
        boolean b = this.accumulateJoins.getAndSet(false);
        assert (b) : "stopAccumulatingJoins() called but not accumulating";
        Map<DiscoveryNode, List<MembershipAction.JoinCallback>> map = this.pendingJoinRequests;
        synchronized (map) {
            if (this.pendingJoinRequests.size() > 0) {
                this.processJoins("pending joins after accumulation stop [" + reason + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleJoinRequest(DiscoveryNode node, MembershipAction.JoinCallback callback) {
        Map<DiscoveryNode, List<MembershipAction.JoinCallback>> map = this.pendingJoinRequests;
        synchronized (map) {
            List<MembershipAction.JoinCallback> nodeCallbacks = this.pendingJoinRequests.get(node);
            if (nodeCallbacks == null) {
                nodeCallbacks = new ArrayList<MembershipAction.JoinCallback>();
                this.pendingJoinRequests.put(node, nodeCallbacks);
            }
            nodeCallbacks.add(callback);
        }
        if (!this.accumulateJoins.get()) {
            this.processJoins("join from node[" + node + "]");
        } else {
            this.checkPendingJoinsAndElectIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPendingJoinsAndElectIfNeeded() {
        assert (this.accumulateJoins.get()) : "election check requested but we are not accumulating joins";
        final ElectionContext context = this.electionContext.get();
        if (context == null) {
            return;
        }
        int pendingMasterJoins = 0;
        Map<DiscoveryNode, List<MembershipAction.JoinCallback>> map = this.pendingJoinRequests;
        synchronized (map) {
            for (DiscoveryNode node : this.pendingJoinRequests.keySet()) {
                if (!node.isMasterNode()) continue;
                ++pendingMasterJoins;
            }
        }
        if (pendingMasterJoins < context.requiredMasterJoins) {
            if (!context.pendingSetAsMasterTask.get()) {
                this.logger.trace("not enough joins for election. Got [{}], required [{}]", pendingMasterJoins, context.requiredMasterJoins);
            }
            return;
        }
        if (context.pendingSetAsMasterTask.getAndSet(true)) {
            this.logger.trace("elected as master task already submitted, ignoring...", new Object[0]);
            return;
        }
        String source = "zen-disco-join(elected_as_master, [" + pendingMasterJoins + "] joins received)";
        this.clusterService.submitStateUpdateTask(source, Priority.IMMEDIATE, new ProcessJoinsTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                if (currentState.nodes().masterNode() != null) {
                    NodeJoinController.this.logger.trace("join thread elected local node as master, but there is already a master in place: {}", currentState.nodes().masterNode());
                    throw new NotMasterException("Node [" + NodeJoinController.this.clusterService.localNode() + "] not master for join request");
                }
                DiscoveryNodes.Builder builder = new DiscoveryNodes.Builder(currentState.nodes()).masterNodeId(currentState.nodes().localNode().id());
                ClusterBlocks clusterBlocks = ClusterBlocks.builder().blocks(currentState.blocks()).removeGlobalBlock(NodeJoinController.this.discoverySettings.getNoMasterBlock()).build();
                currentState = ClusterState.builder(currentState).nodes(builder).blocks(clusterBlocks).build();
                RoutingAllocation.Result result = NodeJoinController.this.routingService.getAllocationService().reroute(currentState);
                if (result.changed()) {
                    currentState = ClusterState.builder(currentState).routingResult(result).build();
                }
                return super.execute(currentState);
            }

            @Override
            public boolean runOnlyOnMaster() {
                return false;
            }

            @Override
            public void onFailure(String source, Throwable t) {
                super.onFailure(source, t);
                context.onFailure(t);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                super.clusterStateProcessed(source, oldState, newState);
                context.onElectedAsMaster(newState);
            }
        });
    }

    private void processJoins(String reason) {
        this.clusterService.submitStateUpdateTask("zen-disco-join(" + reason + ")", Priority.URGENT, new ProcessJoinsTask());
    }

    class ProcessJoinsTask
    extends ProcessedClusterStateUpdateTask {
        private final List<MembershipAction.JoinCallback> joinCallbacksToRespondTo = new ArrayList<MembershipAction.JoinCallback>();
        private boolean nodeAdded = false;

        ProcessJoinsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClusterState execute(ClusterState currentState) {
            DiscoveryNodes.Builder nodesBuilder;
            Map<DiscoveryNode, List<MembershipAction.JoinCallback>> map = NodeJoinController.this.pendingJoinRequests;
            synchronized (map) {
                if (NodeJoinController.this.pendingJoinRequests.isEmpty()) {
                    return currentState;
                }
                nodesBuilder = DiscoveryNodes.builder(currentState.nodes());
                Iterator<Map.Entry<DiscoveryNode, List<MembershipAction.JoinCallback>>> iterator = NodeJoinController.this.pendingJoinRequests.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<DiscoveryNode, List<MembershipAction.JoinCallback>> entry = iterator.next();
                    DiscoveryNode node = entry.getKey();
                    this.joinCallbacksToRespondTo.addAll((Collection<MembershipAction.JoinCallback>)entry.getValue());
                    iterator.remove();
                    if (currentState.nodes().nodeExists(node.id())) {
                        NodeJoinController.this.logger.debug("received a join request for an existing node [{}]", node);
                        continue;
                    }
                    this.nodeAdded = true;
                    nodesBuilder.put(node);
                    for (DiscoveryNode existingNode : currentState.nodes()) {
                        if (!node.address().equals(existingNode.address())) continue;
                        nodesBuilder.remove(existingNode.id());
                        NodeJoinController.this.logger.warn("received join request from node [{}], but found existing node {} with same address, removing existing node", node, existingNode);
                    }
                }
            }
            ClusterState.Builder newState = ClusterState.builder(currentState);
            if (this.nodeAdded) {
                newState.nodes(nodesBuilder);
            }
            return newState.build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNoLongerMaster(String source) {
            Map<DiscoveryNode, List<MembershipAction.JoinCallback>> map = NodeJoinController.this.pendingJoinRequests;
            synchronized (map) {
                Iterator<Map.Entry<DiscoveryNode, List<MembershipAction.JoinCallback>>> iterator = NodeJoinController.this.pendingJoinRequests.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<DiscoveryNode, List<MembershipAction.JoinCallback>> entry = iterator.next();
                    this.joinCallbacksToRespondTo.addAll((Collection<MembershipAction.JoinCallback>)entry.getValue());
                    iterator.remove();
                }
            }
            NotMasterException e = new NotMasterException("Node [" + NodeJoinController.this.clusterService.localNode() + "] not master for join request");
            this.innerOnFailure(e);
        }

        void innerOnFailure(Throwable t) {
            for (MembershipAction.JoinCallback callback : this.joinCallbacksToRespondTo) {
                try {
                    callback.onFailure(t);
                }
                catch (Exception e) {
                    NodeJoinController.this.logger.error("error during task failure", e, new Object[0]);
                }
            }
        }

        @Override
        public void onFailure(String source, Throwable t) {
            NodeJoinController.this.logger.error("unexpected failure during [{}]", t, source);
            this.innerOnFailure(t);
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            if (this.nodeAdded) {
                NodeJoinController.this.routingService.reroute("post_node_add");
            }
            for (MembershipAction.JoinCallback callback : this.joinCallbacksToRespondTo) {
                try {
                    callback.onSuccess();
                }
                catch (Exception e) {
                    NodeJoinController.this.logger.error("unexpected error during [{}]", e, source);
                }
            }
        }
    }

    static abstract class ElectionContext
    implements ElectionCallback {
        private final ElectionCallback callback;
        private final int requiredMasterJoins;
        private final ClusterService clusterService;
        final AtomicBoolean pendingSetAsMasterTask = new AtomicBoolean();
        final AtomicBoolean closed = new AtomicBoolean();

        ElectionContext(ElectionCallback callback, int requiredMasterJoins, ClusterService clusterService) {
            this.callback = callback;
            this.requiredMasterJoins = requiredMasterJoins;
            this.clusterService = clusterService;
        }

        abstract void onClose();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onElectedAsMaster(ClusterState state) {
            assert (this.pendingSetAsMasterTask.get()) : "onElectedAsMaster called but pendingSetAsMasterTask is not set";
            this.assertClusterStateThread();
            assert (state.nodes().localNodeMaster()) : "onElectedAsMaster called but local node is not master";
            if (this.closed.compareAndSet(false, true)) {
                try {
                    this.onClose();
                }
                finally {
                    this.callback.onElectedAsMaster(state);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(Throwable t) {
            this.assertClusterStateThread();
            if (this.closed.compareAndSet(false, true)) {
                try {
                    this.onClose();
                }
                finally {
                    this.callback.onFailure(t);
                }
            }
        }

        private void assertClusterStateThread() {
            assert (!(this.clusterService instanceof InternalClusterService) || ((InternalClusterService)this.clusterService).assertClusterStateThread());
        }
    }

    public static interface ElectionCallback {
        public void onElectedAsMaster(ClusterState var1);

        public void onFailure(Throwable var1);
    }
}

