/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.internal.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class MissingQueryParser
implements QueryParser {
    public static final String NAME = "missing";
    public static final boolean DEFAULT_NULL_VALUE = false;
    public static final boolean DEFAULT_EXISTENCE_VALUE = true;

    @Inject
    public MissingQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldPattern = null;
        String queryName = null;
        boolean nullValue = false;
        boolean existence = true;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token.isValue()) continue;
            if ("field".equals(currentFieldName)) {
                fieldPattern = parser.text();
                continue;
            }
            if ("null_value".equals(currentFieldName)) {
                nullValue = parser.booleanValue();
                continue;
            }
            if ("existence".equals(currentFieldName)) {
                existence = parser.booleanValue();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext, "[missing] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (fieldPattern == null) {
            throw new QueryParsingException(parseContext, "missing must be provided with a [field]", new Object[0]);
        }
        return MissingQueryParser.newFilter(parseContext, fieldPattern, existence, nullValue, queryName);
    }

    public static Query newFilter(QueryParseContext parseContext, String fieldPattern, boolean existence, boolean nullValue, String queryName) {
        Collection<String> fields;
        if (!existence && !nullValue) {
            throw new QueryParsingException(parseContext, "missing must have either existence, or null_value, or both set to true", new Object[0]);
        }
        FieldNamesFieldMapper.FieldNamesFieldType fieldNamesFieldType = (FieldNamesFieldMapper.FieldNamesFieldType)parseContext.mapperService().fullName("_field_names");
        if (fieldNamesFieldType == null) {
            return Queries.newMatchNoDocsQuery();
        }
        ObjectMapper objectMapper = parseContext.getObjectMapper(fieldPattern);
        if (objectMapper != null) {
            fieldPattern = fieldPattern + ".*";
        }
        if ((fields = parseContext.simpleMatchToIndexNames(fieldPattern)).isEmpty()) {
            if (existence) {
                return Queries.newMatchAllQuery();
            }
            return null;
        }
        BooleanQuery existenceFilter = null;
        BooleanQuery nullFilter = null;
        if (existence) {
            BooleanQuery.Builder boolFilter = new BooleanQuery.Builder();
            for (String field : fields) {
                MappedFieldType fieldType = parseContext.fieldMapper(field);
                Query filter = null;
                if (fieldNamesFieldType.isEnabled()) {
                    String f = fieldType != null ? fieldType.names().indexName() : field;
                    filter = fieldNamesFieldType.termQuery(f, parseContext);
                }
                if (filter == null && fieldType != null) {
                    filter = fieldType.rangeQuery(null, null, true, true);
                }
                if (filter == null) {
                    filter = new TermRangeQuery(field, null, null, true, true);
                }
                boolFilter.add(filter, BooleanClause.Occur.SHOULD);
            }
            existenceFilter = boolFilter.build();
            existenceFilter = Queries.not((Query)existenceFilter);
        }
        if (nullValue) {
            for (String field : fields) {
                MappedFieldType fieldType = parseContext.fieldMapper(field);
                if (fieldType == null) continue;
                nullFilter = fieldType.nullValueQuery();
            }
        }
        BooleanQuery filter = nullFilter != null ? (existenceFilter != null ? new BooleanQuery.Builder().add(existenceFilter, BooleanClause.Occur.SHOULD).add((Query)nullFilter, BooleanClause.Occur.SHOULD).build() : nullFilter) : existenceFilter;
        if (filter == null) {
            return null;
        }
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, (Query)existenceFilter);
        }
        return new ConstantScoreQuery((Query)filter);
    }
}

