/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.HashMap;
import java.util.Map;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Glue;
import org.scilab.forge.jlatexmath.InvalidUnitException;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.TeXFormula;

public class SpaceAtom
extends Atom {
    private static Map<String, Integer> units = new HashMap<String, Integer>();
    private static UnitConversion[] unitConversions;
    private boolean blankSpace;
    private int blankType;
    private float width;
    private float height;
    private float depth;
    private int wUnit;
    private int hUnit;
    private int dUnit;

    public SpaceAtom() {
        this.blankSpace = true;
    }

    public SpaceAtom(int n) {
        this.blankSpace = true;
        this.blankType = n;
    }

    public SpaceAtom(int n, float f, float f2, float f3) throws InvalidUnitException {
        SpaceAtom.checkUnit(n);
        this.wUnit = n;
        this.hUnit = n;
        this.dUnit = n;
        this.width = f;
        this.height = f2;
        this.depth = f3;
    }

    public static void checkUnit(int n) throws InvalidUnitException {
        if (n < 0 || n >= unitConversions.length) {
            throw new InvalidUnitException();
        }
    }

    public SpaceAtom(int n, float f, int n2, float f2, int n3, float f3) throws InvalidUnitException {
        SpaceAtom.checkUnit(n);
        SpaceAtom.checkUnit(n2);
        SpaceAtom.checkUnit(n3);
        this.wUnit = n;
        this.hUnit = n2;
        this.dUnit = n3;
        this.width = f;
        this.height = f2;
        this.depth = f3;
    }

    public static int getUnit(String string) {
        Integer n = units.get(string);
        return n == null ? 2 : n;
    }

    public static float[] getLength(String string) {
        int n;
        if (string == null) {
            return new float[]{2.0f, 0.0f};
        }
        for (n = 0; n < string.length() && !Character.isLetter(string.charAt(n)); ++n) {
        }
        float f = 0.0f;
        try {
            f = Float.parseFloat(string.substring(0, n));
        }
        catch (NumberFormatException numberFormatException) {
            return new float[]{Float.NaN};
        }
        int n2 = n != string.length() ? SpaceAtom.getUnit(string.substring(n).toLowerCase()) : 2;
        return new float[]{n2, f};
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        if (this.blankSpace) {
            int n;
            if (this.blankType == 0) {
                return new StrutBox(teXEnvironment.getSpace(), 0.0f, 0.0f, 0.0f);
            }
            int n2 = n = this.blankType < 0 ? -this.blankType : this.blankType;
            Box box = n == 1 ? Glue.get(7, 1, teXEnvironment) : (n == 2 ? Glue.get(2, 1, teXEnvironment) : Glue.get(3, 1, teXEnvironment));
            if (this.blankType < 0) {
                box.negWidth();
            }
            return box;
        }
        return new StrutBox(this.width * SpaceAtom.getFactor(this.wUnit, teXEnvironment), this.height * SpaceAtom.getFactor(this.hUnit, teXEnvironment), this.depth * SpaceAtom.getFactor(this.dUnit, teXEnvironment), 0.0f);
    }

    public static float getFactor(int n, TeXEnvironment teXEnvironment) {
        return unitConversions[n].getPixelConversion(teXEnvironment);
    }

    static {
        units.put("em", 0);
        units.put("ex", 1);
        units.put("px", 2);
        units.put("pix", 2);
        units.put("pixel", 2);
        units.put("pt", 10);
        units.put("bp", 3);
        units.put("pica", 4);
        units.put("pc", 4);
        units.put("mu", 5);
        units.put("cm", 6);
        units.put("mm", 7);
        units.put("in", 8);
        units.put("sp", 9);
        units.put("dd", 11);
        units.put("cc", 12);
        unitConversions = new UnitConversion[]{new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return teXEnvironment.getTeXFont().getEM(teXEnvironment.getStyle());
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return teXEnvironment.getTeXFont().getXHeight(teXEnvironment.getStyle(), teXEnvironment.getLastFontId());
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return 1.0f / teXEnvironment.getSize();
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return TeXFormula.PIXELS_PER_POINT / teXEnvironment.getSize();
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return 12.0f * TeXFormula.PIXELS_PER_POINT / teXEnvironment.getSize();
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                TeXFont teXFont = teXEnvironment.getTeXFont();
                return teXFont.getQuad(teXEnvironment.getStyle(), teXFont.getMuFontId()) / 18.0f;
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return 28.346457f * TeXFormula.PIXELS_PER_POINT / teXEnvironment.getSize();
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return 2.8346457f * TeXFormula.PIXELS_PER_POINT / teXEnvironment.getSize();
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return 72.0f * TeXFormula.PIXELS_PER_POINT / teXEnvironment.getSize();
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return 65536.0f * TeXFormula.PIXELS_PER_POINT / teXEnvironment.getSize();
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return 0.996264f * TeXFormula.PIXELS_PER_POINT / teXEnvironment.getSize();
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return 1.0660349f * TeXFormula.PIXELS_PER_POINT / teXEnvironment.getSize();
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return 12.792419f * TeXFormula.PIXELS_PER_POINT / teXEnvironment.getSize();
            }
        }};
    }

    private static interface UnitConversion {
        public float getPixelConversion(TeXEnvironment var1);
    }
}

