/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi;

import org.intellij.lang.xpath.psi.XPath2Type;
import org.intellij.lang.xpath.psi.XPathType;
import org.jetbrains.annotations.NotNull;

public class XPath2SequenceType
extends XPath2Type {
    private final XPathType myType;

    protected XPath2SequenceType(XPathType s, Cardinality c) {
        super(XPath2SequenceType.makeName(s, c), ANY);
        this.myType = s;
    }

    private static String makeName(XPathType s, Cardinality c) {
        return c.myType != null ? s.getName() + c.myType : "sequence of " + s.getName();
    }

    public XPathType getType() {
        return this.myType;
    }

    public static XPath2Type create(@NotNull XPathType type, Cardinality c) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/intellij/lang/xpath/psi/XPath2SequenceType", "create"));
        }
        return new XPath2SequenceType(type, c);
    }

    public static XPath2Type create(@NotNull XPathType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/intellij/lang/xpath/psi/XPath2SequenceType", "create"));
        }
        return new XPath2SequenceType(type, Cardinality.UNDEFINED);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        XPath2SequenceType that = (XPath2SequenceType)o;
        return this.myType.equals(that.myType);
    }

    @Override
    public boolean isAssignableFrom(@NotNull XPathType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/intellij/lang/xpath/psi/XPath2SequenceType", "isAssignableFrom"));
        }
        return super.isAssignableFrom(type) || this.getType().isAssignableFrom(XPath2SequenceType.unwrap(type));
    }

    private static XPathType unwrap(XPathType type) {
        return type instanceof XPath2SequenceType ? ((XPath2SequenceType)type).getType() : type;
    }

    @Override
    public boolean canBePromotedTo(XPathType type) {
        return super.canBePromotedTo(type) || this.getType().canBePromotedTo(XPath2SequenceType.unwrap(type));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myType.hashCode();
        return result;
    }

    public static enum Cardinality {
        OPTIONAL("?"),
        ONE_OR_MORE("+"),
        ZERO_OR_MORE("*"),
        UNDEFINED(null);

        private final String myType;

        private Cardinality(String c) {
            this.myType = c;
        }
    }
}

