/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.Function;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SameSignatureCallParametersProvider
extends CompletionProvider<CompletionParameters> {
    static final PsiElementPattern.Capture<PsiElement> IN_CALL_ARGUMENT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().beforeLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)JavaTokenType.RPARENTH))).afterLeaf(new String[]{"("})).withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement(PsiExpressionList.class).withParent(PsiCall.class)));

    SameSignatureCallParametersProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/SameSignatureCallParametersProvider", "addCompletions"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/SameSignatureCallParametersProvider", "addCompletions"));
        }
        PsiCall methodCall = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), PsiCall.class);
        assert (methodCall != null);
        Set<Pair<PsiMethod, PsiSubstitutor>> candidates = SameSignatureCallParametersProvider.getCallCandidates(methodCall);
        PsiMethod container = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class);
        while (container != null) {
            for (Pair<PsiMethod, PsiSubstitutor> candidate : candidates) {
                PsiMethod from;
                if (container.getParameterList().getParametersCount() <= 1 || ((PsiMethod)candidate.first).getParameterList().getParametersCount() <= 1 || (from = SameSignatureCallParametersProvider.getMethodToTakeParametersFrom(container, (PsiMethod)candidate.first, (PsiSubstitutor)candidate.second)) == null) continue;
                result2.addElement(SameSignatureCallParametersProvider.createParametersLookupElement(from, (PsiElement)methodCall, (PsiMethod)candidate.first));
            }
            container = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)container, PsiMethod.class);
        }
    }

    private static LookupElement createParametersLookupElement(final PsiMethod takeParametersFrom, PsiElement call, PsiMethod invoked) {
        Object[] parameters = takeParametersFrom.getParameterList().getParameters();
        String lookupString = StringUtil.join((Object[])parameters, (Function)new Function<PsiParameter, String>(){

            public String fun(PsiParameter psiParameter) {
                return psiParameter.getName();
            }
        }, (String)", ");
        int w = PlatformIcons.PARAMETER_ICON.getIconWidth();
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(PlatformIcons.PARAMETER_ICON, 0, 2 * w / 5, 0);
        icon.setIcon(PlatformIcons.PARAMETER_ICON, 1);
        LookupElementBuilder element = LookupElementBuilder.create((String)lookupString).withIcon((Icon)icon);
        if (PsiTreeUtil.isAncestor((PsiElement)takeParametersFrom, (PsiElement)call, (boolean)true)) {
            element = element.withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                public void handleInsert(InsertionContext context, LookupElement item) {
                    context.commitDocument();
                    for (PsiParameter parameter : CompletionUtil.getOriginalOrSelf(takeParametersFrom).getParameterList().getParameters()) {
                        VariableLookupItem.makeFinalIfNeeded(context, (PsiVariable)parameter);
                    }
                }
            });
        }
        element.putUserData(JavaCompletionUtil.SUPER_METHOD_PARAMETERS, (Object)Boolean.TRUE);
        return TailTypeDecorator.withTail(element, ExpectedTypesProvider.getFinalCallParameterTailType(call, invoked.getReturnType(), invoked));
    }

    private static Set<Pair<PsiMethod, PsiSubstitutor>> getCallCandidates(PsiCall expression) {
        LinkedHashSet candidates = ContainerUtil.newLinkedHashSet();
        JavaResolveResult[] results = expression instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)expression).getMethodExpression().multiResolve(false) : new JavaResolveResult[]{expression.resolveMethodGenerics()};
        for (JavaResolveResult candidate : results) {
            PsiClass psiClass;
            PsiElement element = candidate.getElement();
            if (!(element instanceof PsiMethod) || (psiClass = ((PsiMethod)element).getContainingClass()) == null) continue;
            for (Pair overload : psiClass.findMethodsAndTheirSubstitutorsByName(((PsiMethod)element).getName(), true)) {
                candidates.add(Pair.create((Object)overload.first, (Object)candidate.getSubstitutor().putAll((PsiSubstitutor)overload.second)));
            }
            break;
        }
        return candidates;
    }

    @Nullable
    private static PsiMethod getMethodToTakeParametersFrom(PsiMethod place, PsiMethod invoked, PsiSubstitutor substitutor) {
        if (PsiSuperMethodUtil.isSuperMethod((PsiMethod)place, (PsiMethod)invoked)) {
            return place;
        }
        HashMap requiredNames = ContainerUtil.newHashMap();
        PsiParameter[] parameters = place.getParameterList().getParameters();
        PsiParameter[] callParams = invoked.getParameterList().getParameters();
        if (callParams.length > parameters.length) {
            return null;
        }
        boolean checkNames = invoked.isConstructor();
        boolean sameTypes = true;
        for (int i = 0; i < callParams.length; ++i) {
            PsiParameter callParam = callParams[i];
            PsiParameter parameter = parameters[i];
            requiredNames.put(callParam.getName(), substitutor.substitute(callParam.getType()));
            if ((!checkNames || Comparing.equal((String)parameter.getName(), (String)callParam.getName())) && Comparing.equal((Object)parameter.getType(), (Object)substitutor.substitute(callParam.getType()))) continue;
            sameTypes = false;
        }
        if (sameTypes && callParams.length == parameters.length) {
            return place;
        }
        for (PsiParameter parameter : parameters) {
            PsiType type = (PsiType)requiredNames.remove(parameter.getName());
            if (type == null || parameter.getType().equals(type)) continue;
            return null;
        }
        return requiredNames.isEmpty() ? invoked : null;
    }
}

