/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddTypeArgumentsConditionalFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + AddTypeArgumentsConditionalFix.class.getName()));
    private final PsiSubstitutor mySubstitutor;
    private final PsiMethodCallExpression myExpression;
    private final PsiMethod myMethod;

    public AddTypeArgumentsConditionalFix(PsiSubstitutor substitutor, PsiMethodCallExpression expression, PsiMethod method) {
        this.mySubstitutor = substitutor;
        this.myExpression = expression;
        this.myMethod = method;
    }

    @NotNull
    public String getText() {
        if ("Add explicit type arguments" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsConditionalFix", "getText"));
        }
        return "Add explicit type arguments";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsConditionalFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsConditionalFix", "isAvailable"));
        }
        return this.mySubstitutor.isValid() && this.myExpression.isValid() && this.myMethod.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        String withTypeArgsText;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsConditionalFix", "invoke"));
        }
        Object[] typeParameters = this.myMethod.getTypeParameters();
        String typeArguments = "<" + StringUtil.join((Object[])typeParameters, (Function)new Function<PsiTypeParameter, String>(){

            public String fun(PsiTypeParameter parameter) {
                PsiType substituteTypeParam = AddTypeArgumentsConditionalFix.this.mySubstitutor.substitute(parameter);
                LOG.assertTrue(substituteTypeParam != null);
                return GenericsUtil.eliminateWildcards((PsiType)substituteTypeParam).getCanonicalText();
            }
        }, (String)", ") + ">";
        PsiExpression expression = this.myExpression.getMethodExpression().getQualifierExpression();
        if (expression != null) {
            withTypeArgsText = expression.getText();
        } else if (AddTypeArgumentsConditionalFix.isInStaticContext((PsiElement)this.myExpression, null) || this.myMethod.hasModifierProperty("static")) {
            PsiClass aClass = this.myMethod.getContainingClass();
            LOG.assertTrue(aClass != null);
            withTypeArgsText = aClass.getQualifiedName();
        } else {
            withTypeArgsText = "this";
        }
        withTypeArgsText = withTypeArgsText + "." + typeArguments + this.myExpression.getMethodExpression().getReferenceName();
        PsiExpression withTypeArgs = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(withTypeArgsText + this.myExpression.getArgumentList().getText(), (PsiElement)this.myExpression);
        this.myExpression.replace((PsiElement)withTypeArgs);
    }

    public static boolean isInStaticContext(PsiElement element, @Nullable PsiClass aClass) {
        return PsiUtil.getEnclosingStaticElement((PsiElement)element, (PsiClass)aClass) != null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void register(HighlightInfo highlightInfo, PsiExpression expression, @NotNull PsiType lType) {
        if (lType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lType", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsConditionalFix", "register"));
        }
        if (lType != PsiType.NULL && expression instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)expression).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)expression).getElseExpression();
            if (thenExpression != null && elseExpression != null) {
                PsiType thenType = thenExpression.getType();
                PsiType elseType = elseExpression.getType();
                if (thenType != null && elseType != null) {
                    boolean thenAssignable = TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)thenType);
                    boolean elseAssignable = TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)elseType);
                    if (!thenAssignable && thenExpression instanceof PsiMethodCallExpression) {
                        AddTypeArgumentsConditionalFix.inferTypeArgs(highlightInfo, lType, thenExpression);
                    }
                    if (!elseAssignable && elseExpression instanceof PsiMethodCallExpression) {
                        AddTypeArgumentsConditionalFix.inferTypeArgs(highlightInfo, lType, elseExpression);
                    }
                }
            }
        }
    }

    private static void inferTypeArgs(HighlightInfo highlightInfo, PsiType lType, PsiExpression thenExpression) {
        JavaResolveResult result2 = ((PsiMethodCallExpression)thenExpression).resolveMethodGenerics();
        PsiMethod method = (PsiMethod)result2.getElement();
        if (method != null) {
            PsiType returnType = method.getReturnType();
            PsiClass aClass = method.getContainingClass();
            if (returnType != null && aClass != null && aClass.getQualifiedName() != null) {
                JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)method.getProject());
                PsiDeclarationStatement variableDeclarationStatement = javaPsiFacade.getElementFactory().createVariableDeclarationStatement("xxx", lType, thenExpression);
                PsiExpression initializer = ((PsiLocalVariable)variableDeclarationStatement.getDeclaredElements()[0]).getInitializer();
                LOG.assertTrue(initializer != null);
                PsiSubstitutor substitutor = javaPsiFacade.getResolveHelper().inferTypeArguments(method.getTypeParameters(), method.getParameterList().getParameters(), ((PsiMethodCallExpression)thenExpression).getArgumentList().getExpressions(), PsiSubstitutor.EMPTY, (PsiElement)initializer, (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
                PsiType substitutedType = substitutor.substitute(returnType);
                if (substitutedType != null && TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)substitutedType)) {
                    QuickFixAction.registerQuickFixAction(highlightInfo, thenExpression.getTextRange(), new AddTypeArgumentsConditionalFix(substitutor, (PsiMethodCallExpression)thenExpression, method));
                }
            }
        }
    }
}

