/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.scope.processor.VariablesNotProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReuseVariableDeclarationFix
implements IntentionAction {
    private final PsiLocalVariable myVariable;

    public ReuseVariableDeclarationFix(@NotNull PsiLocalVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/quickfix/ReuseVariableDeclarationFix", "<init>"));
        }
        this.myVariable = variable;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("reuse.variable.declaration.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ReuseVariableDeclarationFix", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("reuse.variable.declaration.text", this.myVariable.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ReuseVariableDeclarationFix", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ReuseVariableDeclarationFix", "isAvailable"));
        }
        if (!this.myVariable.isValid()) {
            return false;
        }
        PsiVariable previousVariable = this.findPreviousVariable();
        return previousVariable != null && Comparing.equal((Object)previousVariable.getType(), (Object)this.myVariable.getType()) && this.myVariable.getManager().isInProject((PsiElement)this.myVariable);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ReuseVariableDeclarationFix", "invoke"));
        }
        PsiVariable refVariable = this.findPreviousVariable();
        if (refVariable == null) {
            return;
        }
        if (!CodeInsightUtil.preparePsiElementsForWrite(new PsiElement[]{this.myVariable, refVariable})) {
            return;
        }
        PsiExpression initializer = this.myVariable.getInitializer();
        if (initializer == null) {
            this.myVariable.delete();
            return;
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)refVariable, (String)"final", (boolean)false);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myVariable.getProject()).getElementFactory();
        PsiStatement statement = factory.createStatementFromText(this.myVariable.getName() + " = " + initializer.getText() + ";", null);
        this.myVariable.getParent().replace((PsiElement)statement);
    }

    @Nullable
    private PsiVariable findPreviousVariable() {
        PsiElement scope;
        for (scope = this.myVariable.getParent(); !(scope == null || scope instanceof PsiFile || scope instanceof PsiMethod || scope instanceof PsiClassInitializer); scope = scope.getParent()) {
        }
        if (scope == null) {
            return null;
        }
        PsiIdentifier nameIdentifier = this.myVariable.getNameIdentifier();
        if (nameIdentifier == null) {
            return null;
        }
        VariablesNotProcessor processor2 = new VariablesNotProcessor((PsiVariable)this.myVariable, false);
        PsiScopesUtil.treeWalkUp(processor2, (PsiElement)nameIdentifier, scope);
        return processor2.size() > 0 ? processor2.getResult(0) : null;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

